/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.threading;

import com.oracle.coherence.common.threading.LogExceptionScheduledThreadPoolExecutor;
import com.oracle.coherence.common.threading.LogExceptionThreadPoolExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceFactory {
    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new LogExceptionThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new LogExceptionThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor() {
        return new LogExceptionThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new LogExceptionThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int nThreads) {
        return new LogExceptionScheduledThreadPoolExecutor(nThreads);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new LogExceptionScheduledThreadPoolExecutor(nThreads, threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return new LogExceptionScheduledThreadPoolExecutor(1);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new LogExceptionScheduledThreadPoolExecutor(1, threadFactory);
    }
}

