/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.threading;

import com.oracle.coherence.common.threading.ExecutorListener;
import com.oracle.coherence.common.threading.ObservableExecutor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogExceptionThreadPoolExecutor
extends ThreadPoolExecutor
implements ObservableExecutor {
    private static Logger logger = Logger.getLogger(LogExceptionThreadPoolExecutor.class.getName());
    private ExecutorListener callback;

    public LogExceptionThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public LogExceptionThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                if (((Future)((Object)r)).isDone()) {
                    ((Future)((Object)r)).get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable th) {
                t = th;
            }
        }
        if (this.callback != null) {
            this.callback.afterExecute(r, t);
        }
        if (t != null) {
            logger.log(Level.SEVERE, "Exception {0} thrown during execution of {1}.", new Object[]{t, r});
            StringWriter resultStringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(resultStringWriter);
            t.printStackTrace(pw);
            logger.log(Level.SEVERE, "{0}", resultStringWriter.toString());
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (this.callback != null) {
            this.callback.beforeExecute(r);
        }
    }

    @Override
    public void setCallback(ExecutorListener callback) {
        this.callback = callback;
    }
}

