/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.ticketing;

import com.oracle.coherence.common.identifiers.Identifier;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Ticket
implements Identifier,
ExternalizableLite,
PortableObject,
Comparable<Ticket> {
    public static final Ticket NONE = new Ticket(-1L, -1L);
    private long issuerId;
    private long sequenceNumber;

    public Ticket() {
    }

    public Ticket(long issuerId, long sequenceNumber) {
        this.issuerId = issuerId;
        this.sequenceNumber = sequenceNumber;
    }

    public long getIssuerId() {
        return this.issuerId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void readExternal(DataInput in) throws IOException {
        this.issuerId = ExternalizableHelper.readLong((DataInput)in);
        this.sequenceNumber = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.issuerId);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.sequenceNumber);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.issuerId = reader.readLong(0);
        this.sequenceNumber = reader.readLong(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.issuerId);
        writer.writeLong(1, this.sequenceNumber);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.issuerId ^ this.issuerId >>> 32);
        result = 31 * result + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ticket other = (Ticket)obj;
        if (this.issuerId != other.issuerId) {
            return false;
        }
        return this.sequenceNumber == other.sequenceNumber;
    }

    @Override
    public int compareTo(Ticket other) {
        if (this.getIssuerId() < other.getIssuerId()) {
            return -1;
        }
        if (this.getIssuerId() > other.getIssuerId()) {
            return 1;
        }
        if (this.getSequenceNumber() < other.getSequenceNumber()) {
            return -1;
        }
        if (this.getSequenceNumber() > other.getSequenceNumber()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        if (this.equals(NONE)) {
            return "Ticket.NONE";
        }
        return String.format("Ticket{%d.%d}", this.issuerId, this.sequenceNumber);
    }
}

