/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.ticketing;

import com.oracle.coherence.common.ticketing.Ticket;
import com.oracle.coherence.common.ticketing.TicketBook;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractAggregator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;

public class TicketAggregator
extends AbstractAggregator {
    private transient TreeMap<Long, TreeSet<Ticket>> ticketsByIssuer;
    private transient TreeSet<TicketBook> ticketBooks;

    public TicketAggregator() {
    }

    public TicketAggregator(String methodName) {
        super(methodName);
    }

    public TicketAggregator(ValueExtractor extractor) {
        super(extractor);
    }

    protected void init(boolean isFinal) {
        if (isFinal) {
            this.ticketBooks = new TreeSet();
        } else {
            this.ticketsByIssuer = new TreeMap();
        }
    }

    protected Object finalizeResult(boolean isFinal) {
        if (isFinal) {
            LinkedList<TicketBook> result = new LinkedList<TicketBook>();
            TicketBook ticketBook = null;
            for (TicketBook aTicketBook : this.ticketBooks) {
                if (ticketBook != null && ticketBook.combine(aTicketBook)) continue;
                ticketBook = aTicketBook;
                result.add(ticketBook);
            }
            return result;
        }
        TreeSet<TicketBook> result = new TreeSet<TicketBook>();
        for (long issuerId : this.ticketsByIssuer.keySet()) {
            TicketBook ticketBook = null;
            for (Ticket ticket : this.ticketsByIssuer.get(issuerId)) {
                if (ticketBook != null && ticketBook.add(ticket)) continue;
                ticketBook = new TicketBook(ticket);
                result.add(ticketBook);
            }
        }
        return result;
    }

    protected void process(Object object, boolean isFinal) {
        if (isFinal) {
            this.ticketBooks.addAll((Collection)object);
        } else if (object instanceof Ticket) {
            TreeSet<Object> tickets;
            Ticket ticket = (Ticket)object;
            if (this.ticketsByIssuer.containsKey(ticket.getIssuerId())) {
                tickets = this.ticketsByIssuer.get(ticket.getIssuerId());
            } else {
                tickets = new TreeSet();
                this.ticketsByIssuer.put(ticket.getIssuerId(), tickets);
            }
            tickets.add(ticket);
        }
    }
}

