/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.ticketing;

import com.oracle.coherence.common.ticketing.Ticket;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public class TicketBook
implements Comparable<TicketBook>,
Iterable<Ticket>,
ExternalizableLite,
PortableObject {
    private long issuerId;
    private long from;
    private long to;

    public TicketBook() {
    }

    public TicketBook(long issuerId) {
        this.issuerId = issuerId;
        this.from = 1L;
        this.to = 0L;
    }

    public TicketBook(Ticket ticket) {
        this.issuerId = ticket.getIssuerId();
        this.from = ticket.getSequenceNumber();
        this.to = ticket.getSequenceNumber();
    }

    public TicketBook(long issuerId, long from, long to) {
        this.issuerId = issuerId;
        this.from = from;
        this.to = to;
    }

    public long getIssuerId() {
        return this.issuerId;
    }

    public boolean isEmpty() {
        return this.from > this.to;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public long size() {
        return this.isEmpty() ? 0L : this.to - this.from + 1L;
    }

    public Ticket extend() {
        return new Ticket(this.issuerId, ++this.to);
    }

    public boolean containsTicket(Ticket ticket) {
        return !this.isEmpty() && ticket.getIssuerId() == this.issuerId && ticket.getSequenceNumber() >= this.from && ticket.getSequenceNumber() <= this.to;
    }

    public boolean isAdjacent(Ticket ticket) {
        return ticket.getIssuerId() == this.issuerId && (ticket.getSequenceNumber() == this.from - 1L || ticket.getSequenceNumber() == this.to + 1L);
    }

    public boolean isAdjacent(TicketBook ticketBook) {
        return ticketBook.getIssuerId() == this.issuerId && (ticketBook.getTo() == this.from - 1L || ticketBook.getFrom() == this.to + 1L);
    }

    public boolean intersects(TicketBook ticketBook) {
        return ticketBook.getIssuerId() == this.issuerId && (ticketBook.getFrom() >= this.from && ticketBook.getFrom() <= this.to || ticketBook.getTo() >= this.from && ticketBook.getTo() <= this.to);
    }

    public boolean add(Ticket ticket) {
        if (this.containsTicket(ticket)) {
            return true;
        }
        if (this.isAdjacent(ticket)) {
            if (ticket.getSequenceNumber() == this.from - 1L) {
                --this.from;
            } else {
                ++this.to;
            }
            return true;
        }
        return false;
    }

    public boolean combine(TicketBook ticketBook) {
        if (this.intersects(ticketBook) || this.isAdjacent(ticketBook)) {
            this.from = Math.min(this.from, ticketBook.getFrom());
            this.to = Math.max(this.to, ticketBook.getTo());
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("TicketBook{issuerId=%d, from=%d, to=%d}", this.issuerId, this.from, this.to);
    }

    @Override
    public int compareTo(TicketBook other) {
        if (this.getIssuerId() < other.getIssuerId()) {
            return -1;
        }
        if (this.getIssuerId() > other.getIssuerId()) {
            return 1;
        }
        if (this.from < other.from) {
            return -1;
        }
        if (this.from > other.from) {
            return 1;
        }
        if (this.to < other.to) {
            return -1;
        }
        if (this.to > other.to) {
            return 1;
        }
        return 0;
    }

    public Iterator<Ticket> issue(long n) {
        TicketIterator iterator;
        if (this.isEmpty() || n <= 0L) {
            TicketIterator ticketIterator = new TicketIterator(this.issuerId, this.from, this.from - 1L);
        }
        if (this.size() < n) {
            iterator = new TicketIterator(this.issuerId, this.from, this.to);
            this.from = this.to + 1L;
        } else {
            iterator = new TicketIterator(this.issuerId, this.from, this.from + n - 1L);
            this.from += n;
        }
        return iterator;
    }

    public Iterator<Ticket> first(long n) {
        if (this.isEmpty() || n <= 0L) {
            TicketIterator ticketIterator = new TicketIterator(this.issuerId, this.from, this.from - 1L);
        }
        TicketIterator iterator = this.size() < n ? new TicketIterator(this.issuerId, this.from, this.to) : new TicketIterator(this.issuerId, this.from, this.from + n - 1L);
        return iterator;
    }

    public void consume(long n) {
        if (this.isEmpty() || n <= 0L) {
            // empty if block
        }
        this.from = this.size() < n ? this.to + 1L : (this.from += n);
    }

    @Override
    public Iterator<Ticket> iterator() {
        return new TicketIterator(this.issuerId, this.from, this.to);
    }

    public void readExternal(DataInput in) throws IOException {
        this.issuerId = ExternalizableHelper.readLong((DataInput)in);
        this.from = ExternalizableHelper.readLong((DataInput)in);
        this.to = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.issuerId);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.from);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.to);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.issuerId = reader.readLong(0);
        this.from = reader.readLong(1);
        this.to = reader.readLong(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.issuerId);
        writer.writeLong(1, this.from);
        writer.writeLong(2, this.to);
    }

    private static class TicketIterator
    implements Iterator<Ticket> {
        private long issuerId;
        private long start;
        private long next;
        private long last;

        public TicketIterator(long issuerId, long start, long last) {
            this.issuerId = issuerId;
            this.start = start;
            this.next = start;
            this.last = last;
        }

        @Override
        public boolean hasNext() {
            return this.next <= this.last;
        }

        @Override
        public Ticket next() {
            return new Ticket(this.issuerId, this.next++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove() tickets from a TicketIterator");
        }

        public String toString() {
            return String.format("TicketIterator{issuerId=%d, start=%d, next=%d, last=%d}", this.issuerId, this.start, this.next, this.last);
        }
    }
}

