/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.tuples;

import com.oracle.coherence.common.tuples.Tuple;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class Pair<X, Y>
implements Tuple {
    private X x;
    private Y y;

    public Pair() {
    }

    public Pair(Map.Entry<X, Y> entry) {
        this.x = entry.getKey();
        this.y = entry.getValue();
    }

    public Pair(X x, Y y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public Object get(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        throw new IndexOutOfBoundsException(String.format("%d is an illegal index for a Pair", index));
    }

    @Override
    public int size() {
        return 2;
    }

    public X getX() {
        return this.x;
    }

    public Y getY() {
        return this.y;
    }

    public void readExternal(DataInput in) throws IOException {
        this.x = ExternalizableHelper.readObject((DataInput)in);
        this.y = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.x);
        ExternalizableHelper.writeObject((DataOutput)out, this.y);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.x = reader.readObject(0);
        this.y = reader.readObject(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.x);
        writer.writeObject(1, this.y);
    }

    public String toString() {
        return String.format("Pair<%s, %s>", this.x == null ? "null" : this.x.toString(), this.y == null ? "null" : this.y.toString());
    }
}

