/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.tuples;

import com.oracle.coherence.common.tuples.Tuple;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Triple<X, Y, Z>
implements Tuple {
    private X x;
    private Y y;
    private Z z;

    public Triple() {
    }

    public Triple(X x, Y y, Z z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public Object get(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        if (index == 2) {
            return this.z;
        }
        throw new IndexOutOfBoundsException(String.format("%d is an illegal index for a Triple", index));
    }

    @Override
    public int size() {
        return 3;
    }

    public X getX() {
        return this.x;
    }

    public Y getY() {
        return this.y;
    }

    public Z getZ() {
        return this.z;
    }

    public void readExternal(DataInput in) throws IOException {
        this.x = ExternalizableHelper.readObject((DataInput)in);
        this.y = ExternalizableHelper.readObject((DataInput)in);
        this.z = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.x);
        ExternalizableHelper.writeObject((DataOutput)out, this.y);
        ExternalizableHelper.writeObject((DataOutput)out, this.z);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.x = reader.readObject(0);
        this.y = reader.readObject(1);
        this.z = reader.readObject(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.x);
        writer.writeObject(1, this.y);
        writer.writeObject(2, this.z);
    }

    public String toString() {
        return String.format("Triple<%s, %s, %s>", this.x == null ? "null" : this.x.toString(), this.y == null ? "null" : this.y.toString(), this.z == null ? "null" : this.z.toString());
    }
}

