/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.util.EnrichmentSupport;
import java.util.Collections;
import java.util.HashMap;

public abstract class AbstractEnrichmentSupport
implements EnrichmentSupport {
    private HashMap<Class<?>, HashMap<?, ?>> enrichmentsByType = new HashMap();

    @Override
    public <T, N> void addEnrichment(Class<T> type, N enrichmentKey, T enrichment) {
        HashMap<Object, Object> namedEnrichments = this.enrichmentsByType.get(type);
        if (namedEnrichments == null) {
            namedEnrichments = new HashMap();
            this.enrichmentsByType.put(type, namedEnrichments);
        }
        namedEnrichments.put(enrichmentKey, enrichment);
    }

    @Override
    public void addEnrichmentsFrom(EnrichmentSupport enrichmentSupport) {
        for (Class<?> type : enrichmentSupport.getEnrichmentTypes()) {
            for (Object enrichmentKey : enrichmentSupport.getEnrichmentKeys(type)) {
                this.addEnrichment(type, enrichmentKey, enrichmentSupport.getEnrichment(type, enrichmentKey));
            }
        }
    }

    @Override
    public <T, N> T getEnrichment(Class<T> type, N enrichmentKey) {
        return this.enrichmentsByType.containsKey(type) ? (T)this.enrichmentsByType.get(type).get(enrichmentKey) : null;
    }

    @Override
    public Iterable<?> getEnrichmentKeys(Class<?> type) {
        return this.enrichmentsByType.containsKey(type) ? this.enrichmentsByType.get(type).keySet() : Collections.EMPTY_LIST;
    }

    @Override
    public <T> Iterable<T> getEnrichments(Class<T> type) {
        return this.enrichmentsByType.containsKey(type) ? this.enrichmentsByType.get(type).values() : Collections.EMPTY_LIST;
    }

    @Override
    public Iterable<Class<?>> getEnrichmentTypes() {
        return this.enrichmentsByType.keySet();
    }

    @Override
    public <T, N> boolean hasEnrichment(Class<T> type, N enrichmentKey) {
        return this.getEnrichment(type, enrichmentKey) != null;
    }
}

