/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class ChainedIterator<E>
implements Iterator<E> {
    private LinkedList<Iterator<E>> iterators;

    public ChainedIterator() {
        this.iterators = new LinkedList();
    }

    public ChainedIterator(Iterator<E> ... iterators) {
        this.iterators.addAll(Arrays.asList(iterators));
    }

    public ChainedIterator<E> addIterator(Iterator<E> iterator) {
        this.iterators.addLast(iterator);
        return this;
    }

    @Override
    public boolean hasNext() {
        while (this.iterators.size() > 0 && !this.iterators.get(0).hasNext()) {
            this.iterators.removeFirst();
        }
        return this.iterators.size() > 0;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.iterators.get(0).next();
        }
        throw new IndexOutOfBoundsException("Attempted to iterator past the end of an ChainedIterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from an ChainedIterator");
    }
}

