/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.tangosol.util.Filter;
import java.util.Iterator;

public class FilteringIterator<T>
implements Iterator<T> {
    private Filter filter;
    private Iterator<T> iterator;
    private T next;

    public FilteringIterator(Filter filter, Iterator<T> iterator) {
        this.filter = filter;
        this.iterator = iterator;
        this.next = this.seekNext();
    }

    private T seekNext() {
        Object next = null;
        while (this.iterator != null && this.iterator.hasNext() && next == null) {
            next = this.iterator.next();
            if (this.filter == null || this.filter.evaluate(next)) continue;
            next = null;
        }
        return next;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T result = this.next;
        this.next = this.seekNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove() from a FilteringIterator");
    }
}

