/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.processors.InvokeMethodProcessor;
import com.oracle.coherence.common.util.ObjectChangeCallback;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class NamedCacheObjectProxy<InterfaceType>
implements InvocationHandler,
MapListener {
    private static Logger logger = Logger.getLogger(NamedCacheObjectProxy.class.getName());
    private Object key;
    private NamedCache mCache;
    private volatile CopyOnWriteArrayList<ObjectChangeCallback<InterfaceType>> callbacks;

    public NamedCacheObjectProxy(Object key, NamedCache cache) {
        this.key = key;
        this.mCache = cache;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName() != "toString") {
            InvokeMethodProcessor processor;
            Object value;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Calling method {0} for object with key {1} on cache {2}", new Object[]{method.getName(), this.key, this.mCache.getCacheName()});
            }
            if ((value = this.mCache.invoke(this.key, (InvocableMap.EntryProcessor)(processor = new InvokeMethodProcessor(method.getName(), args)))) instanceof Throwable) {
                throw (Throwable)value;
            }
            return value;
        }
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeCallback(ObjectChangeCallback<InterfaceType> callback) {
        if (this.callbacks == null) {
            this.callbacks = new CopyOnWriteArrayList();
        }
        CopyOnWriteArrayList<ObjectChangeCallback<InterfaceType>> copyOnWriteArrayList = this.callbacks;
        synchronized (copyOnWriteArrayList) {
            if (this.callbacks.isEmpty()) {
                this.mCache.addMapListener((MapListener)this, this.key, false);
            }
            this.callbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChangeCallback(ObjectChangeCallback<InterfaceType> callback) {
        if (this.callbacks == null) {
            this.callbacks = new CopyOnWriteArrayList();
        }
        CopyOnWriteArrayList<ObjectChangeCallback<InterfaceType>> copyOnWriteArrayList = this.callbacks;
        synchronized (copyOnWriteArrayList) {
            this.callbacks.remove(callback);
            if (this.callbacks.isEmpty()) {
                this.mCache.removeMapListener((MapListener)this);
            }
        }
    }

    public String toString() {
        return "NamedCacheObjectProxy {" + this.key + "," + this.mCache.getCacheName() + "}";
    }

    public void entryDeleted(MapEvent mapEvent) {
        if (this.callbacks != null) {
            Iterator<ObjectChangeCallback<InterfaceType>> iter = this.callbacks.iterator();
            while (iter.hasNext()) {
                iter.next().objectDeleted(mapEvent.getKey());
            }
        }
    }

    public void entryInserted(MapEvent mapEvent) {
        if (this.callbacks != null) {
            Iterator<ObjectChangeCallback<InterfaceType>> iter = this.callbacks.iterator();
            while (iter.hasNext()) {
                iter.next().objectCreated(mapEvent.getNewValue());
            }
        }
    }

    public void entryUpdated(MapEvent mapEvent) {
        if (this.callbacks != null) {
            Iterator<ObjectChangeCallback<InterfaceType>> iter = this.callbacks.iterator();
            while (iter.hasNext()) {
                iter.next().objectChanged(mapEvent.getNewValue());
            }
        }
    }
}

