/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.events.dispatching.EventDispatcher;
import com.oracle.coherence.common.events.lifecycle.LifecycleEvent;
import com.oracle.coherence.common.events.lifecycle.LifecycleStartedEvent;
import com.oracle.coherence.common.events.lifecycle.LifecycleStoppedEvent;
import com.oracle.coherence.common.events.lifecycle.NamedCacheStorageReleasedEvent;
import com.oracle.coherence.common.events.processing.AbstractAsynchronousEventProcessor;
import com.oracle.coherence.common.processors.CreateRemoteObjectProcessor;
import com.oracle.coherence.common.util.NamedCacheObjectProxy;
import com.oracle.coherence.common.util.ObjectChangeCallback;
import com.oracle.coherence.environment.Environment;
import com.oracle.coherence.environment.extensible.LifecycleEventFilter;
import com.oracle.coherence.environment.extensible.dependencies.DependencyReference;
import com.oracle.coherence.environment.extensible.dependencies.DependentResource;
import com.oracle.coherence.environment.extensible.dependencies.EnvironmentReference;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectProxyFactory<InterfaceType>
extends AbstractAsynchronousEventProcessor<LifecycleEvent<?>>
implements DependentResource {
    private static Logger logger = Logger.getLogger(ObjectProxyFactory.class.getName());
    private NamedCache mCache;
    private Class<InterfaceType> mClass;
    private String cacheName;

    public ObjectProxyFactory(String cacheName, Class<InterfaceType> clazz) {
        this.cacheName = cacheName;
        this.mClass = clazz;
        this.mCache = null;
    }

    public InterfaceType getProxy(Object key) {
        if (key != null) {
            NamedCache cache = this.ensureCache();
            NamedCacheObjectProxy handler = new NamedCacheObjectProxy(key, cache);
            Object proxy = Proxy.newProxyInstance(this.mClass.getClassLoader(), new Class[]{this.mClass}, handler);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Creating a proxy object for the key {0} for cache {1}.", new Object[]{key, cache.getCacheName()});
            }
            return (InterfaceType)proxy;
        }
        throw new NullPointerException("Can not create an ObjectProxy for a null key");
    }

    public InterfaceType createRemoteObjectIfNotExists(Object key, Class<?> objectType, Object[] parameters) throws Throwable {
        NamedCache cache = this.ensureCache();
        Object result = cache.invoke(key, (InvocableMap.EntryProcessor)new CreateRemoteObjectProcessor(objectType.getName(), parameters));
        if (result instanceof Throwable) {
            throw (Throwable)result;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Creating a Remote object of class {0} for the key {1} for cache {2}.", new Object[]{objectType.getName(), key, cache.getCacheName()});
        }
        return this.getProxy(key);
    }

    public void destroyRemoteObject(Object key) throws Throwable {
        this.ensureCache().remove(key);
    }

    public InterfaceType getLocalCopyOfRemoteObject(Object key) {
        return (InterfaceType)this.ensureCache().get(key);
    }

    public void registerChangeCallback(InterfaceType proxyObject, ObjectChangeCallback<InterfaceType> callback) {
        if (!this.isProxy(proxyObject)) {
            throw new RuntimeException("The object is not a proxy object");
        }
        InvocationHandler invhandler = Proxy.getInvocationHandler(proxyObject);
        if (invhandler instanceof NamedCacheObjectProxy) {
            ((NamedCacheObjectProxy)invhandler).registerChangeCallback(callback);
        }
    }

    public void unregisterChangeCallback(InterfaceType proxyObject, ObjectChangeCallback<InterfaceType> callback) {
        if (!this.isProxy(proxyObject)) {
            throw new RuntimeException("The object is not a proxy object");
        }
        InvocationHandler invhandler = Proxy.getInvocationHandler(proxyObject);
        if (invhandler instanceof NamedCacheObjectProxy) {
            ((NamedCacheObjectProxy)invhandler).unregisterChangeCallback(callback);
        }
    }

    public boolean isProxy(InterfaceType object) {
        return object instanceof Proxy;
    }

    public NamedCache getNamedCache() {
        return this.ensureCache();
    }

    public String toString() {
        return "ObjectProxyFactory for class:" + this.mClass.getName() + " stored in cache:" + this.cacheName;
    }

    private NamedCache ensureCache() {
        if (this.mCache == null) {
            this.mCache = CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(this.getClass().getClassLoader()).ensureCache(this.cacheName, this.getClass().getClassLoader());
        }
        return this.mCache;
    }

    @Override
    public Set<DependencyReference> getDependencyReferences() {
        return Collections.singleton(new EnvironmentReference());
    }

    @Override
    public void onDependenciesSatisfied(Environment environment) {
        this.mCache = this.ensureCache();
        environment.getResource(EventDispatcher.class).dispatchEvent(new LifecycleStartedEvent<ObjectProxyFactory>(this));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Started ObjectProxyFactory for {0} for cache {1}.", new Object[]{this.mClass.getName(), this.cacheName});
        }
        environment.getResource(EventDispatcher.class).registerEventProcessor(LifecycleEventFilter.INSTANCE, this);
    }

    @Override
    public void onDependenciesViolated(Environment environment) {
        this.mCache = null;
        environment.getResource(EventDispatcher.class).dispatchEvent(new LifecycleStoppedEvent<ObjectProxyFactory>(this));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Stopped ObjectProxyFactory for {0} for cache {1}.", new Object[]{this.mClass.getName(), this.cacheName});
        }
    }

    @Override
    public void processLater(EventDispatcher eventDispatcher, LifecycleEvent<?> event) {
        if (event instanceof NamedCacheStorageReleasedEvent && this.cacheName.equals(((NamedCacheStorageReleasedEvent)event).getCacheName())) {
            this.onDependenciesViolated(eventDispatcher.getEnvironment());
        }
    }
}

