/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.AbstractUpdater;
import java.io.IOException;
import java.util.Map;

public class SimpleBinaryEntry
implements BinaryEntry {
    private Binary binaryKey;
    private Binary binaryValue;
    private Binary binaryOriginalValue;
    private Serializer serializer;

    public SimpleBinaryEntry(Binary binaryKey, Binary binaryValue) {
        this((Serializer)new DefaultSerializer(), binaryKey, binaryValue, null);
    }

    public SimpleBinaryEntry(Object key, Object value) {
        this(key, value, null);
    }

    public SimpleBinaryEntry(Binary binaryKey, Binary binaryValue, Binary binaryOriginalValue) {
        this((Serializer)new DefaultSerializer(), binaryKey, binaryValue, binaryOriginalValue);
    }

    public SimpleBinaryEntry(Object key, Object value, Object originalValue) {
        this.serializer = new DefaultSerializer();
        try {
            BinaryWriteBuffer buffer = new BinaryWriteBuffer(200);
            this.serializer.serialize(buffer.getBufferOutput(), key);
            this.binaryKey = buffer.toBinary();
            buffer = new BinaryWriteBuffer(200);
            this.serializer.serialize(buffer.getBufferOutput(), value);
            this.binaryValue = buffer.toBinary();
            buffer = new BinaryWriteBuffer(200);
            this.serializer.serialize(buffer.getBufferOutput(), originalValue);
            this.binaryOriginalValue = buffer.toBinary();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e, (String)"Failed to Serialize the SimpleBinaryEntry parameters");
        }
    }

    public SimpleBinaryEntry(Serializer serializer, Binary binaryKey, Binary binaryValue) {
        this(serializer, binaryKey, binaryValue, null);
    }

    public SimpleBinaryEntry(Serializer serializer, Binary binaryKey, Binary binaryValue, Binary binaryOriginalValue) {
        this.serializer = serializer;
        this.binaryKey = binaryKey;
        this.binaryValue = binaryValue;
        this.binaryOriginalValue = binaryOriginalValue;
    }

    public Binary getBinaryKey() {
        return this.binaryKey;
    }

    public Binary getBinaryValue() {
        return this.binaryValue;
    }

    public Binary getOriginalBinaryValue() {
        return this.binaryOriginalValue;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void expire(long durationMS) {
    }

    public BackingMapContext getBackingMapContext() {
        return null;
    }

    public boolean isPresent() {
        return this.getValue() != null;
    }

    public Object getKey() {
        try {
            if (this.binaryKey == null) {
                return null;
            }
            return this.serializer.deserialize(this.binaryKey.getBufferInput());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    public Object getValue() {
        try {
            if (this.binaryValue == null) {
                return null;
            }
            return this.serializer.deserialize(this.binaryValue.getBufferInput());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    public Object getOriginalValue() {
        try {
            if (this.binaryOriginalValue == null) {
                return null;
            }
            return this.serializer.deserialize(this.binaryOriginalValue.getBufferInput());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    public void remove(boolean isSynthetic) {
        this.setValue(null);
    }

    public Object setValue(Object value) {
        Object currentValue = this.getValue();
        try {
            BinaryWriteBuffer buffer = new BinaryWriteBuffer(200);
            this.serializer.serialize(buffer.getBufferOutput(), value);
            this.binaryValue = buffer.toBinary();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        return currentValue;
    }

    public void setValue(Object value, boolean isSynthetic) {
        this.setValue(value);
    }

    public Object extract(ValueExtractor extractor) {
        return InvocableMapHelper.extractFromEntry((ValueExtractor)extractor, (Map.Entry)((Object)this));
    }

    public void updateBinaryValue(Binary binaryValue) {
        this.binaryValue = binaryValue;
    }

    public void update(ValueUpdater valueUpdater, Object value) {
        if (valueUpdater instanceof AbstractUpdater) {
            ((AbstractUpdater)valueUpdater).updateEntry((Map.Entry)((Object)this), value);
        } else {
            valueUpdater.update(this.getValue(), value);
        }
    }

    public ObservableMap getBackingMap() {
        return null;
    }

    public BackingMapManagerContext getContext() {
        return null;
    }

    public int hashCode() {
        int result = 31 * (this.binaryKey == null ? 0 : this.binaryKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleBinaryEntry other = (SimpleBinaryEntry)obj;
        if (this.binaryKey == null ? other.binaryKey != null : !this.binaryKey.equals((Object)other.binaryKey)) {
            return false;
        }
        if (this.binaryOriginalValue == null ? other.binaryOriginalValue != null : !this.binaryOriginalValue.equals((Object)other.binaryOriginalValue)) {
            return false;
        }
        return !(this.binaryValue == null ? other.binaryValue != null : !this.binaryValue.equals((Object)other.binaryValue));
    }

    public String toString() {
        return String.format("SimpleBinaryEntry{binaryKey=%s (%s), binaryValue=%s (%s), binaryOriginalValue=%s (%s)}", this.binaryKey, this.getKey(), this.binaryValue, this.getValue(), this.binaryOriginalValue, this.getOriginalValue());
    }
}

