/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.util.UniformTransformer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringTransformer
implements UniformTransformer<String> {
    private String matchingRegEx;
    private String transformationRegEx;
    private Pattern matchingPattern;

    public StringTransformer(String matchingRegEx, String transformationRegEx) {
        this.matchingRegEx = matchingRegEx;
        this.transformationRegEx = transformationRegEx;
        this.matchingPattern = Pattern.compile(matchingRegEx);
    }

    public boolean isTransformable(String string) {
        return string.matches(this.matchingRegEx);
    }

    @Override
    public String transform(String string) {
        Matcher matcher = this.matchingPattern.matcher(string);
        return matcher.replaceAll(this.transformationRegEx);
    }

    public String toString() {
        return String.format("StringTransformer{matchingRegEx=%s, transformationRegEx=%s}", this.matchingRegEx, this.transformationRegEx);
    }
}

