/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Tristate
implements ExternalizableLite,
PortableObject {
    public static final Tristate UNDEFINED = new Tristate(-1);
    public static final Tristate FALSE = new Tristate(0);
    public static final Tristate TRUE = new Tristate(1);
    private byte value;

    public Tristate() {
    }

    public Tristate(boolean value) {
        this.value = value ? (byte)1 : 0;
    }

    private Tristate(byte value) {
        this.value = value;
    }

    public boolean isTrue() {
        return this.value == 1;
    }

    public boolean isFalse() {
        return this.value == 0;
    }

    public boolean isUndefined() {
        return this.value == -1;
    }

    public Tristate not() {
        if (this.isUndefined()) {
            return this;
        }
        return this.isTrue() ? FALSE : TRUE;
    }

    public Tristate or(Tristate other) {
        if (this.isTrue()) {
            return this;
        }
        if (this.isFalse()) {
            return other.isTrue() ? other : FALSE;
        }
        return other;
    }

    public Tristate and(Tristate other) {
        if (this.isTrue()) {
            return other;
        }
        if (this.isFalse()) {
            return other.isUndefined() ? other : FALSE;
        }
        return UNDEFINED;
    }

    public void readExternal(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.value = reader.readByte(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeByte(1, this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tristate)) {
            return false;
        }
        Tristate other = (Tristate)obj;
        return this.value == other.value;
    }

    public String toString() {
        return String.format("Tristate{%s}", this.value == 0 ? "FALSE" : (this.value == 1 ? "TRUE" : "UNDEFINED"));
    }
}

