/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UnknownFormatConversionException;

public class Value
implements ExternalizableLite,
PortableObject {
    private static HashMap<Class<?>, Coercer<?>> COERCERS = new HashMap();
    private Object value;

    public Value() {
        this.value = null;
    }

    public Value(boolean value) {
        this.value = value;
    }

    public Value(Object value) {
        this.value = value;
    }

    public Value(String value) {
        this.value = value.trim();
    }

    public Value(Value value) {
        this.value = value.value;
    }

    public Value(XmlValue xmlValue) {
        this.value = xmlValue;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Object getObject() {
        return this.value;
    }

    public BigDecimal getBigDecimal() throws NumberFormatException {
        return this.getValue(BigDecimal.class);
    }

    public boolean getBoolean() throws UnknownFormatConversionException {
        return this.getValue(Boolean.class);
    }

    public byte getByte() throws NumberFormatException {
        return this.getValue(Byte.class);
    }

    public double getDouble() throws NumberFormatException {
        return this.getValue(Double.class);
    }

    public float getFloat() throws NumberFormatException {
        return this.getValue(Float.class).floatValue();
    }

    public int getInt() throws NumberFormatException {
        return this.getValue(Integer.class);
    }

    public long getLong() throws NumberFormatException {
        return this.getValue(Long.class);
    }

    public short getShort() throws NumberFormatException {
        return this.getValue(Short.class);
    }

    public String getString() {
        return this.getValue(String.class);
    }

    public XmlValue getXmlValue() {
        return this.getValue(XmlValue.class);
    }

    public boolean hasCoercerFor(Class<?> clazz) {
        return clazz.isEnum() || clazz.isPrimitive() || COERCERS.containsKey(clazz);
    }

    public <T> T getValue(Class<T> clazz) throws ClassCastException, UnknownFormatConversionException, NumberFormatException {
        if (this.isNull()) {
            return null;
        }
        if (clazz.equals(this.value.getClass())) {
            return (T)this.value;
        }
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return (T)this.value;
        }
        if (clazz.isEnum()) {
            String enumString = (this.value instanceof XmlValue ? ((XmlValue)this.value).getString() : this.value.toString()).trim();
            for (Enum enumValue : (Enum[])clazz.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(enumString)) continue;
                return (T)enumValue;
            }
            throw new ClassCastException(String.format("The specified enumuerated value '%s' is unknown.", enumString));
        }
        if (COERCERS.containsKey(clazz)) {
            Coercer<?> coercer = COERCERS.get(clazz);
            return (T)coercer.coerce(this);
        }
        throw new ClassCastException(String.format("Can't coerce %s into a %s.", this.value, clazz.toString()));
    }

    public boolean isSerializable() {
        return this.value == null || this.value instanceof Serializable || this.value instanceof ExternalizableLite || this.value instanceof PortableObject;
    }

    public void readExternal(DataInput in) throws IOException {
        this.value = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.value);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.value = reader.readObject(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(1, this.value);
    }

    public String toString() {
        return String.format("Value{%s}", this.value);
    }

    static {
        COERCERS.put(BigDecimal.class, new BigDecimalCoercer());
        COERCERS.put(Boolean.class, new BooleanCoercer());
        COERCERS.put(Boolean.TYPE, new BooleanCoercer());
        COERCERS.put(Byte.class, new ByteCoercer());
        COERCERS.put(Byte.TYPE, new ByteCoercer());
        COERCERS.put(Double.class, new DoubleCoercer());
        COERCERS.put(Double.TYPE, new DoubleCoercer());
        COERCERS.put(Float.class, new FloatCoercer());
        COERCERS.put(Float.TYPE, new FloatCoercer());
        COERCERS.put(Integer.class, new IntegerCoercer());
        COERCERS.put(Integer.TYPE, new IntegerCoercer());
        COERCERS.put(Long.class, new LongCoercer());
        COERCERS.put(Long.TYPE, new LongCoercer());
        COERCERS.put(Short.class, new ShortCoercer());
        COERCERS.put(Short.TYPE, new ShortCoercer());
        COERCERS.put(String.class, new StringCoercer());
        COERCERS.put(XmlValue.class, new XmlCoercer());
        COERCERS.put(XmlElement.class, new XmlCoercer());
    }

    private static class XmlCoercer
    implements Coercer<XmlValue> {
        private XmlCoercer() {
        }

        @Override
        public XmlValue coerce(Value value) {
            if (value.value instanceof XmlValue) {
                return (XmlValue)value.value;
            }
            if (value.value instanceof XmlElement) {
                return (XmlElement)value.value;
            }
            return XmlHelper.loadXml((String)value.value.toString());
        }
    }

    private static class StringCoercer
    implements Coercer<String> {
        private StringCoercer() {
        }

        @Override
        public String coerce(Value value) {
            if (value.value instanceof XmlValue) {
                return ((XmlValue)value.value).getString();
            }
            return value.value.toString();
        }
    }

    private static class ShortCoercer
    implements Coercer<Short> {
        private ShortCoercer() {
        }

        @Override
        public Short coerce(Value value) throws NumberFormatException {
            if (value.value instanceof XmlValue) {
                return (short)((XmlValue)value.value).getInt();
            }
            return Short.parseShort(value.value.toString());
        }
    }

    private static class LongCoercer
    implements Coercer<Long> {
        private LongCoercer() {
        }

        @Override
        public Long coerce(Value value) throws NumberFormatException {
            if (value.value instanceof XmlValue) {
                return ((XmlValue)value.value).getLong();
            }
            return Long.parseLong(value.value.toString());
        }
    }

    private static class IntegerCoercer
    implements Coercer<Integer> {
        private IntegerCoercer() {
        }

        @Override
        public Integer coerce(Value value) throws NumberFormatException {
            if (value.value instanceof XmlValue) {
                return ((XmlValue)value.value).getInt();
            }
            return Integer.parseInt(value.value.toString());
        }
    }

    private static class FloatCoercer
    implements Coercer<Float> {
        private FloatCoercer() {
        }

        @Override
        public Float coerce(Value value) throws NumberFormatException {
            if (value.value instanceof XmlValue) {
                return Float.valueOf((float)((XmlValue)value.value).getDouble());
            }
            return Float.valueOf(Float.parseFloat(value.value.toString()));
        }
    }

    private static class DoubleCoercer
    implements Coercer<Double> {
        private DoubleCoercer() {
        }

        @Override
        public Double coerce(Value value) throws NumberFormatException {
            if (value.value instanceof XmlValue) {
                return ((XmlValue)value.value).getDouble();
            }
            return Double.parseDouble(value.value.toString());
        }
    }

    private static class ByteCoercer
    implements Coercer<Byte> {
        private ByteCoercer() {
        }

        @Override
        public Byte coerce(Value value) throws NumberFormatException {
            if (value.value instanceof XmlValue) {
                return Byte.parseByte(((XmlValue)value.value).getString());
            }
            return Byte.parseByte(value.value.toString());
        }
    }

    private static class BooleanCoercer
    implements Coercer<Boolean> {
        private BooleanCoercer() {
        }

        @Override
        public Boolean coerce(Value value) throws UnknownFormatConversionException {
            String proposedBoolean = value.value instanceof XmlValue ? ((XmlValue)value.value).getString().trim() : value.value.toString().trim();
            if (proposedBoolean.equalsIgnoreCase("true") || proposedBoolean.equalsIgnoreCase("yes") || proposedBoolean.equalsIgnoreCase("on")) {
                return true;
            }
            if (proposedBoolean.equalsIgnoreCase("false") || proposedBoolean.equalsIgnoreCase("no") || proposedBoolean.equalsIgnoreCase("off")) {
                return false;
            }
            throw new UnknownFormatConversionException(String.format("The value [%s] is not a boolean (true, yes, on, false, no, off, args)", proposedBoolean));
        }
    }

    private static class BigDecimalCoercer
    implements Coercer<BigDecimal> {
        private BigDecimalCoercer() {
        }

        @Override
        public BigDecimal coerce(Value value) throws NumberFormatException {
            if (value.value instanceof XmlValue) {
                return ((XmlValue)value.value).getDecimal();
            }
            return new BigDecimal(value.value.toString());
        }
    }

    public static interface Coercer<T> {
        public T coerce(Value var1) throws ClassCastException;
    }
}

