/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.configuration.caching;

import com.oracle.coherence.common.util.AbstractEnrichmentSupport;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;

public class CacheMapping
extends AbstractEnrichmentSupport {
    private String cacheName;
    private String schemeName;
    private ParameterProvider parameterProvider;

    public CacheMapping(String cacheName, String schemeName, ParameterProvider parameterProvider) {
        this.cacheName = cacheName.trim();
        this.schemeName = schemeName.trim();
        this.parameterProvider = parameterProvider == null ? SystemPropertyParameterProvider.INSTANCE : parameterProvider;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public boolean isForCacheName(String cacheName) {
        if (this.getCacheName().equals("*")) {
            return true;
        }
        if (this.getCacheName().contains("*")) {
            String pattern = this.getCacheName().substring(0, this.getCacheName().indexOf("*"));
            return cacheName.startsWith(pattern);
        }
        return false;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public ParameterProvider getParameterProvider() {
        return this.parameterProvider;
    }
}

