/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.configuration.caching;

import com.oracle.coherence.configuration.caching.CacheMapping;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheMappingRegistry {
    private static final Logger logger = Logger.getLogger(CacheMappingRegistry.class.getName());
    private LinkedHashMap<String, CacheMapping> cacheMappings = new LinkedHashMap();

    public boolean addCacheMapping(CacheMapping cacheMapping) {
        CacheMapping existingCacheMapping = this.cacheMappings.get(cacheMapping.getCacheName());
        if (existingCacheMapping != null) {
            logger.log(Level.CONFIG, "WARNING: The cache mapping for the <cache-name>{0}</cache-name> has been duplicated/overridden.The new cache mapping declaration for <cache-name>{0}</cache-name> will be ignored, but decorations will be retained and merged.", cacheMapping.getCacheName());
            existingCacheMapping.addEnrichmentsFrom(cacheMapping);
            return false;
        }
        existingCacheMapping = this.findCacheMapping(cacheMapping.getCacheName());
        if (existingCacheMapping != null) {
            logger.log(Level.CONFIG, "WARNING: The cache mapping for the <cache-name>{0}</cache-name> matches an existing declaration called <cache-name>{1}</cache-name>.While the cache mapping for <cache-name>{0}</cache-name> will be accepted, it may never be used due to the existing overriding declaration of <cache-name>{1}</cache-name>.", new Object[]{cacheMapping.getCacheName(), existingCacheMapping.getCacheName()});
        }
        this.cacheMappings.put(cacheMapping.getCacheName(), cacheMapping);
        return true;
    }

    public CacheMapping findCacheMapping(String cacheName) {
        CacheMapping cacheMapping;
        if (this.cacheMappings.containsKey(cacheName)) {
            cacheMapping = this.cacheMappings.get(cacheName);
        } else {
            cacheMapping = null;
            for (CacheMapping mapping : this.cacheMappings.values()) {
                if (!mapping.isForCacheName(cacheName)) continue;
                if (cacheMapping == null) {
                    cacheMapping = mapping;
                    continue;
                }
                if (mapping.getCacheName().length() <= cacheMapping.getCacheName().length()) continue;
                cacheMapping = mapping;
            }
        }
        return cacheMapping;
    }
}

