/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.configuration.expressions;

import com.oracle.coherence.common.util.Value;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MacroParameterExpression
implements Expression,
ExternalizableLite,
PortableObject {
    private String expression;

    public MacroParameterExpression() {
    }

    public MacroParameterExpression(String expression) {
        this.expression = expression.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value evaluate(ParameterProvider parameterProvider) {
        Value result = null;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.expression.length(); ++i) {
            if (this.expression.charAt(i) == '{') {
                String parameterDefaultValue;
                int endMacroPos;
                String parameterName;
                int defaultValuePos = this.expression.indexOf(" ", i + 1);
                if (defaultValuePos >= 0) {
                    parameterName = this.expression.substring(i + 1, defaultValuePos).trim();
                    endMacroPos = this.expression.indexOf("}", defaultValuePos);
                    if (endMacroPos <= defaultValuePos) throw new IllegalArgumentException(String.format("Invalid parameter macro definition in [%s].  Missing closing brace '}'.", this.expression));
                    parameterDefaultValue = this.expression.substring(defaultValuePos, endMacroPos).trim();
                    i = endMacroPos;
                } else {
                    endMacroPos = this.expression.indexOf("}", i + 1);
                    if (endMacroPos <= i + 1) throw new IllegalArgumentException(String.format("Invalid parameter macro definition in [%s].  Missing closing brace '}'.", this.expression));
                    parameterName = this.expression.substring(i + 1, endMacroPos).trim();
                    parameterDefaultValue = null;
                    i = endMacroPos;
                }
                if (parameterProvider.isDefined(parameterName)) {
                    result = parameterProvider.getParameter(parameterName).evaluate(parameterProvider);
                } else {
                    if (parameterDefaultValue == null) throw new IllegalArgumentException(String.format("The specified parameter name '%s' in the macro parameter '%s' is unknown and not resolvable", parameterName, this.expression));
                    result = new Value(parameterDefaultValue);
                }
                if (builder.length() <= 0) continue;
                builder.append(result.getString());
                result = null;
                continue;
            }
            if (result != null) {
                builder.append(result.getString());
                result = null;
            }
            if (this.expression.startsWith("\\{", i)) {
                builder.append("{");
                ++i;
                continue;
            }
            if (this.expression.startsWith("\\}", i)) {
                builder.append("}");
                ++i;
                continue;
            }
            builder.append(this.expression.charAt(i));
        }
        return result == null ? new Value(builder.toString()) : result;
    }

    public String toString() {
        return String.format("MacroParameterExpression{expression=%s}", this.expression);
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    public void readExternal(DataInput in) throws IOException {
        this.expression = ExternalizableHelper.readSafeUTF((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.expression);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.expression = reader.readString(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(1, this.expression);
    }
}

