/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.configuration.parameters;

import com.oracle.coherence.common.util.Value;
import com.oracle.coherence.configuration.expressions.Constant;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Parameter
implements Expression,
ExternalizableLite,
PortableObject {
    private String name;
    private String type;
    private Expression expression;

    public Parameter() {
    }

    public Parameter(String name, boolean value) {
        this.name = name;
        this.type = Boolean.TYPE.getName();
        this.expression = new Constant(value);
    }

    public Parameter(String name, Expression expression) {
        this.name = name;
        this.type = null;
        this.expression = expression;
    }

    public Parameter(String name, Object value) {
        this.name = name;
        this.type = null;
        this.expression = new Constant(value);
    }

    public Parameter(String name, String value) {
        this.name = name;
        this.type = String.class.getName();
        this.expression = new Constant(value);
    }

    public Parameter(String name, String type, Expression expression) {
        this.name = name;
        this.type = type;
        this.expression = expression;
    }

    public Parameter(String name, String type, Value value) {
        this.name = name;
        this.type = type;
        this.expression = new Constant(value);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isStronglyTyped() {
        return this.type != null;
    }

    @Override
    public boolean isSerializable() {
        return this.expression.isSerializable();
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Value evaluate(ParameterProvider parameterProvider) {
        return this.expression.evaluate(parameterProvider);
    }

    public void readExternal(DataInput in) throws IOException {
        this.name = ExternalizableHelper.readSafeUTF((DataInput)in);
        this.type = ExternalizableHelper.readSafeUTF((DataInput)in);
        this.expression = (Expression)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.name);
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.type);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.expression);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.name = reader.readString(1);
        this.type = reader.readString(2);
        this.expression = (Expression)reader.readObject(3);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(1, this.name);
        writer.writeString(2, this.type);
        writer.writeObject(3, (Object)this.expression);
    }

    public String toString() {
        String result = "";
        if (this.name != null) {
            result = result + "name=" + this.getName();
        }
        if (this.type != null) {
            result = result + (result.isEmpty() ? "" : ", ") + "type=" + this.getType();
        }
        result = result + (result.isEmpty() ? "" : ", ") + "expression=" + this.getExpression();
        return "Parameter{" + result + "}";
    }
}

