/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.configuration.parameters;

import com.oracle.coherence.configuration.parameters.EmptyParameterProvider;
import com.oracle.coherence.configuration.parameters.MutableParameterProvider;
import com.oracle.coherence.configuration.parameters.Parameter;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.oracle.coherence.configuration.parameters.SimpleParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class ScopedParameterProvider
implements MutableParameterProvider,
ExternalizableLite,
PortableObject {
    private MutableParameterProvider parameterProvider = new SimpleParameterProvider();
    private ParameterProvider innerParameterProvider;

    public ScopedParameterProvider() {
        this(EmptyParameterProvider.INSTANCE);
    }

    public ScopedParameterProvider(ParameterProvider parameterProvider) {
        this.innerParameterProvider = parameterProvider;
    }

    @Override
    public void addParameter(Parameter parameter) {
        this.parameterProvider.addParameter(parameter);
    }

    @Override
    public Parameter getParameter(String name) throws ClassCastException {
        if (this.parameterProvider.isDefined(name)) {
            return this.parameterProvider.getParameter(name);
        }
        return this.innerParameterProvider.getParameter(name);
    }

    @Override
    public boolean isDefined(String name) {
        return this.parameterProvider.isDefined(name) || this.innerParameterProvider.isDefined(name);
    }

    @Override
    public boolean isEmpty() {
        return this.innerParameterProvider.isEmpty() && this.parameterProvider.isEmpty();
    }

    @Override
    public int size() {
        return this.innerParameterProvider.size() + this.parameterProvider.size();
    }

    @Override
    public Iterator<Parameter> iterator() {
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        for (Parameter parameter : this.parameterProvider) {
            parameters.put(parameter.getName(), parameter);
        }
        for (Parameter parameter : this.innerParameterProvider) {
            if (parameters.containsKey(parameter.getName())) continue;
            parameters.put(parameter.getName(), parameter);
        }
        return parameters.values().iterator();
    }

    @Override
    public Map<String, ?> getParameters(ParameterProvider parameterProvider) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Parameter parameter : this) {
            Object value = parameter.isStronglyTyped() ? parameter.getExpression().evaluate(parameterProvider).getObject() : parameter.getExpression().evaluate(parameterProvider).getObject();
            parameters.put(parameter.getName(), value);
        }
        return parameters;
    }

    @Override
    public Properties getProperties(ParameterProvider parameterProvider) {
        Properties properties = new Properties();
        for (Parameter parameter : this) {
            properties.put(parameter.getName(), parameter.getExpression().evaluate(parameterProvider).getString());
        }
        return properties;
    }

    public void readExternal(DataInput in) throws IOException {
        this.innerParameterProvider = (ParameterProvider)ExternalizableHelper.readObject((DataInput)in);
        this.parameterProvider = (MutableParameterProvider)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.innerParameterProvider);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.parameterProvider);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.innerParameterProvider = (ParameterProvider)reader.readObject(1);
        this.parameterProvider = (MutableParameterProvider)reader.readObject(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(1, (Object)this.innerParameterProvider);
        writer.writeObject(2, (Object)this.parameterProvider);
    }

    public String toString() {
        return String.format("ScopedParameterProvider{parameterProvider=%s, innerParameterProvider=%s}", this.parameterProvider, this.innerParameterProvider);
    }
}

