/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.configuration.parameters;

import com.oracle.coherence.configuration.parameters.MutableParameterProvider;
import com.oracle.coherence.configuration.parameters.Parameter;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class SimpleParameterProvider
implements MutableParameterProvider,
ExternalizableLite,
PortableObject {
    private LinkedHashMap<String, Parameter> parameters = new LinkedHashMap();

    @Override
    public void addParameter(Parameter parameter) {
        this.parameters.put(parameter.getName(), parameter);
    }

    @Override
    public Parameter getParameter(String name) throws ClassCastException {
        return this.parameters.get(name);
    }

    @Override
    public boolean isDefined(String name) {
        return this.parameters.containsKey(name);
    }

    @Override
    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public Iterator<Parameter> iterator() {
        return this.parameters.values().iterator();
    }

    @Override
    public Map<String, ?> getParameters(ParameterProvider parameterProvider) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Parameter parameter : this) {
            Object value = parameter.isStronglyTyped() ? parameter.getExpression().evaluate(parameterProvider).getObject() : parameter.getExpression().evaluate(parameterProvider).getObject();
            parameters.put(parameter.getName(), value);
        }
        return parameters;
    }

    @Override
    public Properties getProperties(ParameterProvider parameterProvider) {
        Properties properties = new Properties();
        for (Parameter parameter : this) {
            properties.put(parameter.getName(), parameter.getExpression().evaluate(parameterProvider).getString());
        }
        return properties;
    }

    public String toString() {
        return String.format("SimpleParameterProvider{parameters=%s}", this.parameters);
    }

    protected Map<String, Parameter> getSerializableParameters() {
        LinkedHashMap<String, Parameter> serializableParameters = new LinkedHashMap<String, Parameter>();
        for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
            if (!entry.getValue().isSerializable()) continue;
            serializableParameters.put(entry.getKey(), entry.getValue());
        }
        return serializableParameters;
    }

    public void readExternal(DataInput in) throws IOException {
        this.parameters = new LinkedHashMap();
        ExternalizableHelper.readMap((DataInput)in, this.parameters, (ClassLoader)this.getClass().getClassLoader());
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeMap((DataOutput)out, this.getSerializableParameters());
    }

    public void readExternal(PofReader reader) throws IOException {
        this.parameters = new LinkedHashMap();
        reader.readMap(1, this.parameters);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeMap(1, this.getSerializableParameters());
    }
}

