/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.configuration.parameters;

import com.oracle.coherence.configuration.parameters.Parameter;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SystemPropertyParameterProvider
implements ParameterProvider,
ExternalizableLite,
PortableObject {
    public static final SystemPropertyParameterProvider INSTANCE = new SystemPropertyParameterProvider();

    @Override
    public boolean isDefined(String name) {
        return System.getProperties().containsKey(name);
    }

    @Override
    public Parameter getParameter(String name) {
        if (this.isDefined(name)) {
            return new Parameter(name, System.getProperty(name));
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return System.getProperties().isEmpty();
    }

    @Override
    public int size() {
        return System.getProperties().size();
    }

    @Override
    public Iterator<Parameter> iterator() {
        final Enumeration<?> propertyNames = System.getProperties().propertyNames();
        return new Iterator<Parameter>(){

            @Override
            public boolean hasNext() {
                return propertyNames.hasMoreElements();
            }

            @Override
            public Parameter next() {
                String propertyName = (String)propertyNames.nextElement();
                return new Parameter(propertyName, System.getProperty(propertyName));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove a parameter from an SystemPropertyParameterProvider");
            }
        };
    }

    @Override
    public Map<String, ?> getParameters(ParameterProvider parameterProvider) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    @Override
    public Properties getProperties(ParameterProvider parameterProvider) {
        return System.getProperties();
    }

    public void readExternal(DataInput in) throws IOException {
    }

    public void writeExternal(DataOutput out) throws IOException {
    }

    public void readExternal(PofReader reader) throws IOException {
    }

    public void writeExternal(PofWriter writer) throws IOException {
    }
}

