/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible;

import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.common.builders.ReflectiveBuilder;
import com.oracle.coherence.common.logging.LogHelper;
import com.oracle.coherence.common.util.AbstractEnrichmentSupport;
import com.oracle.coherence.common.util.EnrichmentSupport;
import com.oracle.coherence.common.util.Value;
import com.oracle.coherence.configuration.Mandatory;
import com.oracle.coherence.configuration.Property;
import com.oracle.coherence.configuration.SubType;
import com.oracle.coherence.configuration.Type;
import com.oracle.coherence.configuration.expressions.Constant;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.expressions.MacroParameterExpression;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.oracle.coherence.environment.Environment;
import com.oracle.coherence.environment.extensible.AttributeContentHandler;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.ElementContentHandler;
import com.oracle.coherence.environment.extensible.NamespaceContentHandler;
import com.oracle.coherence.environment.extensible.QualifiedName;
import com.oracle.coherence.environment.extensible.namespaces.NullNamespaceContentHandler;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UUID;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultConfigurationContext
implements ConfigurationContext,
EnrichmentSupport {
    private static final Logger logger = Logger.getLogger(DefaultConfigurationContext.class.getName());
    private Environment environment;
    private LinkedList<Scope> scopes;

    public DefaultConfigurationContext(Environment environment) {
        this.environment = environment;
        this.scopes = new LinkedList();
        this.scopes.addFirst(new Scope(this, null));
    }

    @Override
    public NamespaceContentHandler ensureNamespaceContentHandler(String prefix, URI uri) {
        NamespaceContentHandler namespaceContentHandler = this.getNamespaceContentHandler(uri);
        if (!(namespaceContentHandler != null || (namespaceContentHandler = this.getNamespaceContentHandler(prefix)) != null && prefix.isEmpty())) {
            namespaceContentHandler = this.getCurrentScope().establishNamespaceContentHandlerFor(prefix, uri);
        }
        return namespaceContentHandler;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public NamespaceContentHandler getNamespaceContentHandler(String prefix) {
        NamespaceContentHandler namespaceContentHandler = null;
        Iterator scopeIterator = this.scopes.iterator();
        while (scopeIterator.hasNext() && namespaceContentHandler == null) {
            Scope scope = (Scope)scopeIterator.next();
            URI uri = scope.getNamespaceURI(prefix);
            namespaceContentHandler = uri == null ? null : this.getNamespaceContentHandler(uri);
        }
        return namespaceContentHandler;
    }

    @Override
    public NamespaceContentHandler getNamespaceContentHandler(URI uri) {
        NamespaceContentHandler namespaceContentHandler = null;
        Iterator scopeIterator = this.scopes.iterator();
        while (scopeIterator.hasNext() && namespaceContentHandler == null) {
            Scope scope = (Scope)scopeIterator.next();
            namespaceContentHandler = scope.getNamespaceContentHandler(uri);
        }
        return namespaceContentHandler;
    }

    @Override
    public URI getNamespaceURI(String prefix) {
        return this.getCurrentScope().getNamespaceURI(prefix);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getEnvironment().getClassLoader();
    }

    private Scope getCurrentScope() {
        return this.scopes.getFirst();
    }

    private void startScope(XmlElement xmlElement) {
        this.scopes.addFirst(new Scope(this, xmlElement));
    }

    private void endScope() {
        this.getCurrentScope().terminate();
        this.scopes.removeFirst();
    }

    @Override
    public Object processDocument(XmlElement xmlElement) throws ConfigurationException {
        XmlHelper.replaceSystemProperties((XmlElement)xmlElement, (String)"system-property");
        return this.processElement(xmlElement);
    }

    @Override
    public Object processDocument(String xml) throws ConfigurationException {
        return this.processDocument((XmlElement)XmlHelper.loadXml((String)xml));
    }

    @Override
    public Object processDocumentAt(URI uri) throws ConfigurationException {
        return this.processDocument((XmlElement)DefaultConfigurableCacheFactory.loadConfigAsResource((String)uri.toString(), (ClassLoader)this.getClassLoader()));
    }

    @Override
    public Object processDocumentAt(String location) throws ConfigurationException {
        return this.processDocument((XmlElement)DefaultConfigurableCacheFactory.loadConfigAsResource((String)location, (ClassLoader)this.getClassLoader()));
    }

    @Override
    public Object processElement(XmlElement xmlElement) throws ConfigurationException {
        this.startScope(xmlElement);
        for (String attributeName : xmlElement.getAttributeMap().keySet()) {
            QualifiedName attributeQName = new QualifiedName(attributeName);
            if (!attributeQName.getPrefix().equals("xmlns") && (attributeQName.hasPrefix() || !attributeQName.getLocalName().equals("xmlns"))) continue;
            XmlValue uriValue = xmlElement.getAttribute(attributeName);
            try {
                this.ensureNamespaceContentHandler(attributeQName.hasPrefix() ? attributeQName.getLocalName() : "", new URI(uriValue.getString()));
            }
            catch (URISyntaxException uriSyntaxException) {
                throw new RuntimeException(String.format("Invalid URI '%s' specified for XML namespace '%s'", uriValue.getString(), attributeQName.getPrefix()), uriSyntaxException);
            }
        }
        QualifiedName elementQName = new QualifiedName(xmlElement);
        NamespaceContentHandler namespaceContentHandler = this.getNamespaceContentHandler(elementQName.getPrefix());
        if (namespaceContentHandler == null || !(namespaceContentHandler instanceof ElementContentHandler)) {
            throw new RuntimeException(String.format("An ElementContentHandler is not available for the element [%s].  Please check that the namespace has been correctly defined", elementQName));
        }
        Map attributeMap = xmlElement.getAttributeMap();
        for (String key : attributeMap.keySet()) {
            QualifiedName attributeQName = new QualifiedName(key);
            NamespaceContentHandler attributeNamespaceContentHandler = this.getNamespaceContentHandler(attributeQName.getPrefix());
            if (!attributeQName.getPrefix().equals("xmlns") && attributeNamespaceContentHandler == null) {
                throw new RuntimeException(String.format("An AttributeContentHandler is not available for the attribute [%s] in the namespace [%s], in the element [%s].  Please check that the namespace has been correctly defined", attributeQName, attributeQName.getPrefix(), elementQName));
            }
            if (attributeNamespaceContentHandler == null || !(attributeNamespaceContentHandler instanceof AttributeContentHandler)) continue;
            ((AttributeContentHandler)((Object)attributeNamespaceContentHandler)).onAttribute(this, attributeQName, (XmlValue)attributeMap.get(key));
        }
        Object result = ((ElementContentHandler)((Object)namespaceContentHandler)).onElement(this, elementQName, xmlElement);
        this.endScope();
        return result;
    }

    @Override
    public Object processElement(String xml) throws ConfigurationException {
        return this.processElement((XmlElement)XmlHelper.loadXml((String)xml));
    }

    @Override
    public Object processOnlyElementOf(XmlElement xmlElement) throws ConfigurationException {
        if (xmlElement.getElementList().size() == 1) {
            return this.processElement((XmlElement)xmlElement.getElementList().get(0));
        }
        throw new ConfigurationException(String.format("Only a single element is permitted in the %s element.", xmlElement), String.format("Please consult the documentation regarding use of the '%s' namespace", new QualifiedName(xmlElement).getPrefix()));
    }

    @Override
    public <T> T processElementOf(XmlElement xmlElement, QualifiedName qualifiedName, T defaultValue) throws ConfigurationException {
        Object result;
        XmlElement childElement = xmlElement.getElement(qualifiedName.toString());
        if (childElement == null) {
            result = defaultValue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.config(String.format("Using the default value of [%s] for the xml element <%s> in element <%s>", defaultValue, qualifiedName.getName(), xmlElement.getName()));
            }
        } else {
            result = this.processElement(childElement);
        }
        return result;
    }

    @Override
    public <T> T processElementOf(XmlElement xmlElement, String id, T defaultValue) throws ConfigurationException {
        Object result;
        XmlElement childElement = null;
        Iterator children = xmlElement.getElementList().iterator();
        while (children.hasNext() && childElement == null) {
            XmlElement anElement = (XmlElement)children.next();
            XmlValue idXmlValue = anElement.getAttribute("id");
            if (idXmlValue == null || !idXmlValue.getString().equals(id)) continue;
            childElement = anElement;
        }
        if (childElement == null) {
            result = defaultValue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.config(String.format("Using the default value of [%s] for the xml element with id='%s' in element <%s>", defaultValue, id, xmlElement.getName()));
            }
        } else {
            result = this.processElement(childElement);
        }
        return result;
    }

    @Override
    public Map<String, ?> processElementsOf(XmlElement xmlElement, QualifiedName ... except) throws ConfigurationException {
        HashSet<QualifiedName> exceptions = new HashSet<QualifiedName>();
        for (QualifiedName exception : except) {
            exceptions.add(exception);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (XmlElement childElement : xmlElement.getElementList()) {
            String id;
            QualifiedName childQName = new QualifiedName(childElement);
            if (exceptions.contains(childQName)) continue;
            String string = id = childElement.getAttributeMap().containsKey("id") ? childElement.getAttribute("id").getString() : new UUID().toString();
            if (id.trim().length() == 0) {
                id = new UUID().toString();
            }
            result.put(id, this.processElement(childElement));
        }
        return result;
    }

    @Override
    public <T> Map<String, T> processElementsOf(XmlElement xmlElement, Class<T> expectedType) throws ConfigurationException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (XmlElement childElement : xmlElement.getElementList()) {
            Object child;
            String id;
            String string = id = childElement.getAttributeMap().containsKey("id") ? childElement.getAttribute("id").getString() : new UUID().toString();
            if (id.trim().length() == 0) {
                id = new UUID().toString();
            }
            if (expectedType.isAssignableFrom((child = this.processElement(childElement)).getClass())) {
                result.put(id, child);
                continue;
            }
            throw new ConfigurationException(String.format("The child element %s of the %s element did not produce the expected type %s when processed.", childElement, xmlElement, expectedType), String.format("Please consult the documentation regarding use of the '%s' namespace", new QualifiedName(xmlElement).getPrefix()));
        }
        return result;
    }

    @Override
    public boolean isPropertyDefined(String propertyName, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        if (xmlElement.getAttribute(propertyName) == null) {
            QualifiedName propertyQName = new QualifiedName(qualifiedName.getPrefix(), propertyName);
            if (xmlElement.getElement(propertyQName.getName()) == null) {
                propertyQName = new QualifiedName("", propertyName);
                return xmlElement.getElement(propertyQName.getName()) != null;
            }
            return true;
        }
        return true;
    }

    @Override
    public void configure(Object object, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            LogHelper.entering(logger, DefaultConfigurationContext.class.getName(), "configure");
        }
        for (Method method : object.getClass().getMethods()) {
            if (method.getAnnotation(Property.class) == null || method.getParameterTypes().length != 1) continue;
            Property property = method.getAnnotation(Property.class);
            String propertyName = property.value();
            if (this.isPropertyDefined(propertyName, qualifiedName, xmlElement)) {
                Class<?> propertyType = method.getAnnotation(Type.class) == null ? method.getParameterTypes()[0] : method.getAnnotation(Type.class).value();
                Class<?> propertySubType = method.getAnnotation(SubType.class) == null ? null : method.getAnnotation(SubType.class).value();
                Object propertyValue = this.getMandatoryProperty(propertyName, propertyType, propertySubType, qualifiedName, xmlElement);
                try {
                    method.invoke(object, propertyValue);
                    continue;
                }
                catch (Exception exception) {
                    throw new ConfigurationException(String.format("Could not set the property '%s' using reflection against the annotated method '%s' of '%s'", propertyName, method, object.getClass().getName()), String.format("Please resolve the causing exception.", this.getNamespaceContentHandler(qualifiedName.getPrefix()).getClass().getName()), exception);
                }
            }
            if (this.isMandatory(method, xmlElement)) {
                throw new ConfigurationException(String.format("The mandatory property '%s' is not defined in element '%s'.", propertyName, xmlElement), String.format("Please consult the documentation for the use of the %s namespace", qualifiedName.getPrefix()));
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer(String.format("The property '%s' does not have a defined value in the element '%s'. Will use the default value.", propertyName, xmlElement));
        }
        if (logger.isLoggable(Level.FINER)) {
            LogHelper.exiting(logger, DefaultConfigurationContext.class.getName(), "configure");
        }
    }

    protected boolean isMandatory(Method m, XmlElement element) {
        return m.getAnnotation(Mandatory.class) != null && element.getElement("scheme-ref") == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T getMandatoryProperty(String propertyName, Class<T> propertyType, Class<?> propertySubType, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        Object propertyValue;
        QualifiedName propertyQName;
        Value value = new Value(xmlElement.getAttribute(propertyName));
        if (value.isNull() && (value = new Value((XmlValue)xmlElement.getElement((propertyQName = new QualifiedName(qualifiedName.getPrefix(), propertyName)).getName()))).isNull()) {
            propertyQName = new QualifiedName("", propertyName);
            value = new Value((XmlValue)xmlElement.getElement(propertyQName.getName()));
        }
        if (value.isNull()) {
            throw new ConfigurationException(String.format("The expected property '%s' is not defined in element '%s'.", propertyName, xmlElement), String.format("Please consult the documentation for the use of the %s namespace", qualifiedName.getPrefix()));
        }
        if (value.hasCoercerFor(propertyType)) {
            try {
                propertyValue = value.getValue(propertyType);
                return propertyValue;
            }
            catch (ClassCastException classCastException) {
                throw new ConfigurationException(String.format("Incompatible Types: The specified value '%s' for the property '%s' in element '%s' can not be converted into the required property type '%s'.", value.getString(), propertyName, value.getObject(), propertyType), String.format("Please ensure a correct type of value is specified for the property '%s' in the namespace '%s'.", propertyName, qualifiedName.getPrefix()), classCastException);
            }
        }
        if (propertyType == Expression.class) {
            if (value.getObject() instanceof XmlElement && ((XmlElement)value.getObject()).getElementList().size() == 1) {
                try {
                    Object processedValue = this.processOnlyElementOf((XmlElement)value.getObject());
                    if (processedValue instanceof Expression) {
                        propertyValue = processedValue;
                        return propertyValue;
                    }
                    propertyValue = new Constant(processedValue);
                    return propertyValue;
                }
                catch (ConfigurationException configurationException) {
                    throw new ConfigurationException(String.format("The type of the '%s' property is not supported for declarative configuration.", propertyName), String.format("The namespace implementation '%s' will need to programmatically configure the said property.", this.getNamespaceContentHandler(qualifiedName.getPrefix()).getClass().getName()), configurationException);
                }
            } else {
                propertyValue = new MacroParameterExpression(value.getString());
            }
            return propertyValue;
        }
        if (!(value.getObject() instanceof XmlElement)) throw new ConfigurationException(String.format("The type of the '%s' property for the element '%s' is not supported for declarative configuration.", propertyName, xmlElement), String.format("The namespace implementation '%s' will need to programmatically configure the said property.", this.getNamespaceContentHandler(qualifiedName.getPrefix()).getClass().getName()));
        try {
            propertyValue = this.processElement((XmlElement)value.getObject());
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationException(String.format("The type of the '%s' property is not supported for declarative configuration.", propertyName), String.format("The namespace implementation '%s' will need to programmatically configure the said property.", this.getNamespaceContentHandler(qualifiedName.getPrefix()).getClass().getName()), configurationException);
        }
        if (propertyValue == null) return propertyValue;
        if (propertyType.isAssignableFrom(propertyValue.getClass())) {
            if (propertySubType == null || (!(propertyValue instanceof ReflectiveBuilder) || ((ReflectiveBuilder)propertyValue).realizesClassOf(propertySubType, SystemPropertyParameterProvider.INSTANCE)) && (propertyValue instanceof ReflectiveBuilder || propertySubType.isAssignableFrom(propertyValue.getClass()))) return propertyValue;
            throw new ConfigurationException(String.format("Incompatible Types: The specified value '%s' for the property '%s' in element '%s' is incompatible with the required '%s' property type.", propertyValue, propertyName, value.getObject(), propertySubType), String.format("The namespace implementation '%s' will need to programmatically configure the said property.", this.getNamespaceContentHandler(qualifiedName.getPrefix()).getClass().getName()));
        }
        if (!(propertyValue instanceof ParameterizedBuilder) || !((ParameterizedBuilder)propertyValue).realizesClassOf(propertyType, SystemPropertyParameterProvider.INSTANCE)) throw new ConfigurationException(String.format("Incompatible Types: The specified value '%s' for the property '%s' in element %s is incompatible with the declared type (by the property setter method).", propertyValue, propertyName, value.getString()), String.format("The namespace implementation '%s' will need to programmatically configure the said property.", this.getNamespaceContentHandler(qualifiedName.getPrefix()).getClass().getName()));
        propertyValue = ((ParameterizedBuilder)propertyValue).realize(SystemPropertyParameterProvider.INSTANCE);
        return propertyValue;
    }

    @Override
    public <T> T getMandatoryProperty(String propertyName, Class<T> propertyType, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        return this.getMandatoryProperty(propertyName, propertyType, null, qualifiedName, xmlElement);
    }

    @Override
    public <T> T getOptionalProperty(String propertyName, Class<T> propertyType, Class<?> propertySubType, T defaultValue, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        if (this.isPropertyDefined(propertyName, qualifiedName, xmlElement)) {
            return this.getMandatoryProperty(propertyName, propertyType, propertySubType, qualifiedName, xmlElement);
        }
        return defaultValue;
    }

    @Override
    public <T> T getOptionalProperty(String propertyName, Class<T> propertyType, T defaultValue, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        if (this.isPropertyDefined(propertyName, qualifiedName, xmlElement)) {
            return this.getMandatoryProperty(propertyName, propertyType, qualifiedName, xmlElement);
        }
        return defaultValue;
    }

    @Override
    public <T, N> boolean hasEnrichment(Class<T> type, N decorationKey) {
        return this.getCurrentScope().hasEnrichment(type, decorationKey);
    }

    @Override
    public <T, N> T getEnrichment(Class<T> type, N decorationKey) {
        T decoration = null;
        Iterator scopeIterator = this.scopes.iterator();
        while (scopeIterator.hasNext() && decoration == null) {
            Scope scope = (Scope)scopeIterator.next();
            decoration = scope.getEnrichment(type, decorationKey);
        }
        return decoration;
    }

    @Override
    public Iterable<?> getEnrichmentKeys(Class<?> type) {
        return this.getCurrentScope().getEnrichmentKeys(type);
    }

    @Override
    public <T> Iterable<T> getEnrichments(Class<T> type) {
        return this.getCurrentScope().getEnrichments(type);
    }

    @Override
    public Iterable<Class<?>> getEnrichmentTypes() {
        return this.getCurrentScope().getEnrichmentTypes();
    }

    @Override
    public <T, N> void addEnrichment(Class<T> type, N decorationKey, T decoration) {
        this.getCurrentScope().addEnrichment(type, decorationKey, decoration);
    }

    @Override
    public void addEnrichmentsFrom(EnrichmentSupport decorationSupport) {
        this.getCurrentScope().addEnrichmentsFrom(decorationSupport);
    }

    public String toString() {
        String result = "DefaultConfigurationContext{\n";
        for (Scope scope : this.scopes) {
            result = result + scope + "\n";
        }
        return result + "}";
    }

    private class Scope
    extends AbstractEnrichmentSupport {
        private ConfigurationContext context;
        private XmlElement xmlElement;
        private HashMap<String, URI> namespaces;
        private HashMap<URI, NamespaceContentHandler> namespaceContentHandlers;

        Scope(ConfigurationContext context, XmlElement xmlElement) {
            this.context = context;
            this.xmlElement = xmlElement;
            this.namespaces = new HashMap();
            this.namespaceContentHandlers = new HashMap();
        }

        XmlElement getXmlElement() {
            return this.xmlElement;
        }

        URI getNamespaceURI(String prefix) {
            return this.namespaces.get(prefix);
        }

        NamespaceContentHandler getNamespaceContentHandler(URI uri) {
            return this.namespaceContentHandlers.get(uri);
        }

        NamespaceContentHandler establishNamespaceContentHandlerFor(String prefix, URI uri) {
            String scheme = uri.getScheme();
            if (this.namespaces.containsKey(prefix)) {
                throw new RuntimeException(String.format("Duplicate definition for the namespace prefix [%s] encountered with URI [%s]\n", prefix, uri));
            }
            if (scheme.equalsIgnoreCase("class")) {
                String fqcn = uri.getHost() == null ? uri.getSchemeSpecificPart() : uri.getHost();
                try {
                    Class clazz = ExternalizableHelper.loadClass((String)fqcn, (ClassLoader)this.context.getClass().getClassLoader(), null);
                    if (NamespaceContentHandler.class.isAssignableFrom(clazz)) {
                        try {
                            NamespaceContentHandler namespaceHandler = (NamespaceContentHandler)clazz.newInstance();
                            namespaceHandler.onStartScope(this.context, prefix, uri);
                            this.namespaceContentHandlers.put(uri, namespaceHandler);
                            this.namespaces.put(prefix, uri);
                            return namespaceHandler;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(String.format("Can't instantiate the NamespaceContentHandler [%s]\n", fqcn), exception);
                        }
                    }
                    throw new RuntimeException(String.format("The declared NamespaceContentHandler [%s] does not implement the %s interface\n", fqcn, NamespaceContentHandler.class.getName()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(String.format("Can't instantiate the NamespaceContentHandler [%s] as the class is not found\n", fqcn), classNotFoundException);
                }
            }
            if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) {
                NullNamespaceContentHandler namespaceContentHandler = new NullNamespaceContentHandler();
                this.namespaceContentHandlers.put(uri, namespaceContentHandler);
                this.namespaces.put(prefix, uri);
                return namespaceContentHandler;
            }
            throw new RuntimeException(String.format("Can't create a NamespaceContentHandler as the URI scheme [%s] in [%s] is not supported\n", uri.getScheme(), uri));
        }

        void terminate() {
            for (String prefix : this.namespaces.keySet()) {
                URI uri = this.namespaces.get(prefix);
                this.namespaceContentHandlers.get(uri).onEndScope(this.context, prefix, uri);
            }
        }

        public String toString() {
            String result = "";
            result = result + "Scope<" + (this.getXmlElement() == null ? "root" : this.xmlElement.getName()) + ">{";
            if (!this.namespaces.isEmpty()) {
                result = result + "namespaces=" + this.namespaces;
            }
            if (!this.namespaceContentHandlers.isEmpty()) {
                result = result + "handlers=" + this.namespaceContentHandlers;
            }
            return result + "}";
        }
    }
}

