/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible;

import com.oracle.coherence.common.builders.BuilderRegistry;
import com.oracle.coherence.common.builders.NoArgsBuilder;
import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.common.events.dispatching.EventDispatcher;
import com.oracle.coherence.common.events.dispatching.SimpleEventDispatcher;
import com.oracle.coherence.common.events.lifecycle.LifecycleStartedEvent;
import com.oracle.coherence.common.events.lifecycle.LifecycleStoppedEvent;
import com.oracle.coherence.common.events.lifecycle.NamedCacheStorageRealizedEvent;
import com.oracle.coherence.common.events.lifecycle.NamedCacheStorageReleasedEvent;
import com.oracle.coherence.common.logging.CoherenceLogHandler;
import com.oracle.coherence.common.logging.LogHelper;
import com.oracle.coherence.common.threading.ExecutorServiceFactory;
import com.oracle.coherence.common.threading.ThreadFactories;
import com.oracle.coherence.configuration.caching.CacheMapping;
import com.oracle.coherence.configuration.caching.CacheMappingRegistry;
import com.oracle.coherence.configuration.parameters.Parameter;
import com.oracle.coherence.configuration.parameters.ScopedParameterProvider;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.oracle.coherence.environment.Environment;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.DefaultConfigurationContext;
import com.oracle.coherence.environment.extensible.LifecycleEventFilter;
import com.oracle.coherence.environment.extensible.dependencies.DependencyTracker;
import com.oracle.coherence.environment.extensible.dependencies.DependentResource;
import com.oracle.coherence.environment.extensible.namespaces.CoherenceNamespaceContentHandler;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtensibleEnvironment
extends DefaultConfigurableCacheFactory
implements Environment {
    private static final Logger logger = Logger.getLogger(ExtensibleEnvironment.class.getName());
    private static ThreadLocal<ConfigurationContext> configurationContext = new ThreadLocal();
    private ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Object>> resourcesByClass;
    private ConcurrentHashMap<String, Service> trackedServices;
    private HashSet<String> trackedNamedCaches;

    public ExtensibleEnvironment() {
    }

    public ExtensibleEnvironment(String path) {
        super(path);
    }

    public ExtensibleEnvironment(XmlElement xmlConfig) {
        super(xmlConfig);
    }

    public ExtensibleEnvironment(String path, ClassLoader loader) {
        super(path, loader);
    }

    @Override
    public <R> R getResource(Class<R> clazz) {
        return this.getResource(clazz, "");
    }

    @Override
    public <R> R registerResource(Class<R> clazz, Object resource) {
        return this.registerResource(clazz, "", resource);
    }

    @Override
    public <R> R getResource(Class<R> clazz, String name) {
        if (this.resourcesByClass.containsKey(clazz)) {
            return (R)this.resourcesByClass.get(clazz).get(name);
        }
        return null;
    }

    @Override
    public <R> Map<String, R> getResources(Class<R> clazz) {
        Map resourcesByName = this.resourcesByClass.get(clazz);
        return resourcesByName == null ? Collections.EMPTY_MAP : resourcesByName;
    }

    @Override
    public synchronized <R> R registerResource(Class<R> clazz, String name, NoArgsBuilder<R> builder) {
        Object resource;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Attempted to registerResource(%s, null) with a null name.  null names are not supported", clazz));
        }
        ConcurrentHashMap<String, Object> resourcesByName = this.resourcesByClass.get(clazz);
        if (resourcesByName == null) {
            resourcesByName = new ConcurrentHashMap();
            this.resourcesByClass.put(clazz, resourcesByName);
        }
        if ((resource = resourcesByName.get(name)) == null) {
            resource = builder.realize();
            resourcesByName.put(name, resource);
            if (resource instanceof DependentResource) {
                this.getResource(EventDispatcher.class).registerEventProcessor(LifecycleEventFilter.INSTANCE, new DependencyTracker(this, (DependentResource)resource));
            }
        } else {
            logger.warning(String.format("Environment resource [%s] of type [%s] is already registered as [%s].  Skipping requested registration.", name, clazz, resource));
        }
        return (R)resource;
    }

    @Override
    public <R> R registerResource(Class<R> clazz, String name, final Object resource) {
        return this.registerResource(clazz, name, new NoArgsBuilder<R>(){

            @Override
            public R realize() {
                return resource;
            }
        });
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getConfigClassLoader();
    }

    private void startup() {
        CacheFactory.log((String)"", (int)0);
        CacheFactory.log((String)"Using the Incubator Extensible Environment for Coherence Cache Configuration", (int)0);
        CacheFactory.log((String)"Copyright (c) 2013, Oracle Corporation. All Rights Reserved.", (int)0);
        CacheFactory.log((String)"", (int)0);
        this.resourcesByClass = new ConcurrentHashMap();
        this.trackedServices = new ConcurrentHashMap();
        this.trackedNamedCaches = new HashSet();
        this.registerResource(BuilderRegistry.class, new BuilderRegistry());
        this.registerResource(EventDispatcher.class, new SimpleEventDispatcher(this));
        this.registerResource(ExecutorService.class, ExecutorServiceFactory.newSingleThreadExecutor(ThreadFactories.newThreadFactory(true, "Environment.Background.Executor", null)));
    }

    private void shutdown() {
        if (logger.isLoggable(Level.FINEST)) {
            LogHelper.entering(logger, this.getClass().getName(), "shutdown");
        }
        EventDispatcher eventDispatcher = this.getResource(EventDispatcher.class);
        for (String cacheName : this.trackedNamedCaches) {
            eventDispatcher.dispatchEvent(new NamedCacheStorageReleasedEvent(cacheName));
        }
        for (Service service : this.trackedServices.values()) {
            eventDispatcher.dispatchEvent(new LifecycleStoppedEvent<Service>(service));
        }
        eventDispatcher.dispatchEvent(new LifecycleStoppedEvent<ExtensibleEnvironment>(this));
        this.getResource(ExecutorService.class).shutdown();
        if (logger.isLoggable(Level.FINEST)) {
            LogHelper.exiting(logger, this.getClass().getName(), "shutdown");
        }
    }

    private String fullStackTraceFor(Thread thread) {
        int dropStackTraceElements = 2;
        StringBuilder result = new StringBuilder();
        result.append("Stack Trace\n");
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            if (dropStackTraceElements == 0) {
                result.append(stackTraceElement);
                result.append("\n");
                continue;
            }
            --dropStackTraceElements;
        }
        return result.toString();
    }

    public void setConfig(XmlElement xmlConfig) {
        CoherenceNamespaceContentHandler coherenceNamespaceContentHandler;
        if (configurationContext.get() != null) {
            String message = "An attempt to recursively load and process a Coherence Cache Configuration has occurred. This is usually caused by accessing a NamedCache or Service (through the CacheFactory) from a NamespaceContentHandler, ElementContentHandler and/or AttributeContentHandler.";
            logger.severe(message);
            logger.severe(this.fullStackTraceFor(Thread.currentThread()));
            logger.severe(configurationContext.get().toString());
            throw new RuntimeException(message);
        }
        DefaultConfigurationContext context = new DefaultConfigurationContext(this);
        configurationContext.set(context);
        CoherenceLogHandler.initializeIncubatorLogging();
        if (logger.isLoggable(Level.FINEST)) {
            LogHelper.entering(logger, this.getClass().getName(), "setConfig", xmlConfig);
        }
        if (this.resourcesByClass != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Extensible Environment XML configuration has been reset.  Will now restart it.");
            }
            this.shutdown();
        }
        this.startup();
        try {
            coherenceNamespaceContentHandler = (CoherenceNamespaceContentHandler)context.ensureNamespaceContentHandler("", new URI(String.format("class:%s", CoherenceNamespaceContentHandler.class.getName())));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException("FATAL ERROR: The internal URI created by the ExtensibleEnvironment is invalid.", uriSyntaxException);
        }
        try {
            context.processDocument(xmlConfig);
            coherenceNamespaceContentHandler.onEndScope(context, "", context.getNamespaceURI(""));
            StringBuilder builder = new StringBuilder();
            coherenceNamespaceContentHandler.build(builder);
            XmlDocument xmlDocument = XmlHelper.loadXml((String)builder.toString());
            super.setConfig((XmlElement)xmlDocument);
        }
        catch (ConfigurationException configurationException) {
            logger.log(Level.SEVERE, configurationException.toString());
            throw ExtensibleEnvironment.ensureRuntimeException((Throwable)configurationException);
        }
        finally {
            configurationContext.set(null);
        }
        this.getResource(EventDispatcher.class).dispatchEventLater(new LifecycleStartedEvent<ExtensibleEnvironment>(this));
        if (logger.isLoggable(Level.FINEST)) {
            LogHelper.exiting(logger, this.getClass().getName(), "setConfig");
        }
    }

    public Service ensureService(XmlElement element) {
        final EventDispatcher eventDispatcher = this.getResource(EventDispatcher.class);
        XmlElement serviceSchemeElement = this.resolveScheme(element, null, false, false);
        final String serviceName = serviceSchemeElement.getSafeElement("service-name").getString();
        boolean isTrackedService = this.trackedServices.containsKey(serviceName);
        Service service = super.ensureService(element);
        String serviceType = service.getInfo().getServiceType();
        if (serviceName.length() > 0 && !serviceType.equals("LocalCache")) {
            if (isTrackedService) {
                Service previousService = this.trackedServices.get(serviceName);
                if (service != previousService) {
                    eventDispatcher.dispatchEvent(new LifecycleStoppedEvent<Service>(previousService));
                    this.trackedServices.put(serviceName, service);
                    eventDispatcher.dispatchEvent(new LifecycleStartedEvent<Service>(service));
                }
            } else {
                this.trackedServices.put(serviceName, service);
                eventDispatcher.dispatchEvent(new LifecycleStartedEvent<Service>(service));
                service.addServiceListener(new ServiceListener(){

                    public void serviceStopping(ServiceEvent serviceEvent) {
                    }

                    public void serviceStopped(ServiceEvent serviceEvent) {
                        if (serviceEvent.getService() instanceof Service) {
                            eventDispatcher.dispatchEvent(new LifecycleStoppedEvent<Service>((Service)serviceEvent.getService()));
                            ExtensibleEnvironment.this.trackedServices.remove(serviceName);
                        }
                    }

                    public void serviceStarting(ServiceEvent serviceEvent) {
                    }

                    public void serviceStarted(ServiceEvent serviceEvent) {
                        if (serviceEvent.getService() instanceof Service) {
                            eventDispatcher.dispatchEvent(new LifecycleStartedEvent<Service>((Service)serviceEvent.getService()));
                            ExtensibleEnvironment.this.trackedServices.put(serviceName, (Service)serviceEvent.getService());
                        }
                    }
                });
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackNamedCacheStorage(String cacheName) {
        boolean raiseEvent = false;
        HashSet<String> hashSet = this.trackedNamedCaches;
        synchronized (hashSet) {
            boolean bl = raiseEvent = !this.trackedNamedCaches.contains(cacheName);
            if (raiseEvent) {
                this.trackedNamedCaches.add(cacheName);
            }
        }
        if (raiseEvent) {
            this.getResource(EventDispatcher.class).dispatchEvent(new NamedCacheStorageRealizedEvent(cacheName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untrackNamedCacheStorage(String cacheName) {
        boolean raiseEvent = false;
        HashSet<String> hashSet = this.trackedNamedCaches;
        synchronized (hashSet) {
            raiseEvent = this.trackedNamedCaches.contains(cacheName);
            if (raiseEvent) {
                this.trackedNamedCaches.remove(cacheName);
            }
        }
        if (raiseEvent) {
            this.getResource(EventDispatcher.class).dispatchEvent(new NamedCacheStorageReleasedEvent(cacheName));
        }
    }

    protected void register(CacheService cacheService, String cacheName, String context, Map map) {
        super.register(cacheService, cacheName, context, map);
        this.trackNamedCacheStorage(cacheName);
    }

    protected void unregister(CacheService cacheService, String cacheName) {
        super.unregister(cacheService, cacheName);
        this.untrackNamedCacheStorage(cacheName);
    }

    protected void unregister(String cacheName, String context) {
        super.unregister(cacheName, context);
        this.untrackNamedCacheStorage(cacheName);
    }

    public Object instantiateAny(DefaultConfigurableCacheFactory.CacheInfo info, XmlElement xmlClass, BackingMapManagerContext context, ClassLoader loader) {
        if (xmlClass.getName().equals("class-scheme") && xmlClass.getAttributeMap().containsKey("use-scheme")) {
            String schemeId = xmlClass.getAttribute("use-scheme").getString();
            try {
                ParameterizedBuilder builder = (ParameterizedBuilder)this.getResource(BuilderRegistry.class).getBuilder(schemeId);
                CacheMapping cacheMapping = this.getResource(CacheMappingRegistry.class).findCacheMapping(info.getCacheName());
                ScopedParameterProvider parameterProvider = new ScopedParameterProvider(cacheMapping == null ? SystemPropertyParameterProvider.INSTANCE : cacheMapping.getParameterProvider());
                for (Map.Entry attributeEntry : info.getAttributes().entrySet()) {
                    parameterProvider.addParameter(new Parameter(attributeEntry.getKey().toString(), attributeEntry.getValue()));
                }
                parameterProvider.addParameter(new Parameter("cache-name", info.getCacheName()));
                parameterProvider.addParameter(new Parameter("class-loader", loader));
                parameterProvider.addParameter(new Parameter("manager-context", context));
                if (builder instanceof ClassLoaderAware) {
                    ((ClassLoaderAware)builder).setContextClassLoader(loader);
                }
                return builder.realize(parameterProvider);
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException(String.format("Cound not instantiate %s as the namespace did not return a ClassScheme.", xmlClass), classCastException);
            }
        }
        return super.instantiateAny(info, xmlClass, context, loader);
    }
}

