/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible;

import com.tangosol.run.xml.XmlElement;
import java.util.UnknownFormatConversionException;

public class QualifiedName {
    private String prefix;
    private String localName;

    public QualifiedName(String xmlName) throws UnknownFormatConversionException {
        String[] parts = xmlName.trim().split(":");
        if (parts.length == 1) {
            this.prefix = "";
            this.localName = xmlName.trim();
        } else if (parts.length == 2) {
            this.prefix = parts[0].trim();
            this.localName = parts[1].trim();
        } else {
            throw new UnknownFormatConversionException(String.format("The specified xmlName [%s] can't be parsed into a QualifiedName", xmlName));
        }
    }

    public QualifiedName(XmlElement xmlElement) throws UnknownFormatConversionException {
        this(xmlElement.getName());
    }

    public QualifiedName(QualifiedName qualifiedName, String localName) {
        this.prefix = qualifiedName.getPrefix();
        this.localName = localName;
    }

    public QualifiedName(String prefix, String localName) {
        this.prefix = prefix.trim();
        this.localName = localName.trim();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean hasPrefix() {
        return this.prefix.length() > 0;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getName() {
        return this.hasPrefix() ? String.format("%s:%s", this.getPrefix(), this.getLocalName()) : this.getLocalName();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedName other = (QualifiedName)obj;
        if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }
}

