/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible.dependencies;

import com.oracle.coherence.common.events.dispatching.EventDispatcher;
import com.oracle.coherence.common.events.lifecycle.LifecycleEvent;
import com.oracle.coherence.common.events.lifecycle.LifecycleStartedEvent;
import com.oracle.coherence.common.events.lifecycle.LifecycleStoppedEvent;
import com.oracle.coherence.common.events.processing.AbstractAsynchronousEventProcessor;
import com.oracle.coherence.environment.Environment;
import com.oracle.coherence.environment.extensible.dependencies.DependencyReference;
import com.oracle.coherence.environment.extensible.dependencies.DependentResource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DependencyTracker
extends AbstractAsynchronousEventProcessor<LifecycleEvent<?>> {
    private static Logger logger = Logger.getLogger(DependencyTracker.class.getName());
    private Environment environment;
    private DependentResource dependentResource;
    private HashMap<DependencyReference, Status> dependenciesStatus;

    public DependencyTracker(Environment environment, DependentResource dependentResource) {
        this.environment = environment;
        this.dependentResource = dependentResource;
        this.dependenciesStatus = new HashMap();
        for (DependencyReference dependencyReference : dependentResource.getDependencyReferences()) {
            this.dependenciesStatus.put(dependencyReference, Status.Stopped);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Created DependencyTracker for {0}\n", dependentResource);
        }
    }

    public DependentResource getDependentResource() {
        return this.dependentResource;
    }

    public boolean areDependenciesSatisfied() {
        boolean isSatisfied = true;
        Iterator<Status> statuses = this.dependenciesStatus.values().iterator();
        while (statuses.hasNext() && isSatisfied) {
            isSatisfied = isSatisfied && statuses.next() == Status.Started;
        }
        return isSatisfied;
    }

    @Override
    public void processLater(EventDispatcher eventDispatcher, LifecycleEvent<?> event) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "DependencyTracker for {0}: Received Lifecycle Event {1}\n", new Object[]{this.dependentResource, event});
        }
        DependencyReference dependencyReference = null;
        Iterator<DependencyReference> dependencyReferences = this.dependenciesStatus.keySet().iterator();
        while (dependencyReferences.hasNext() && dependencyReference == null) {
            dependencyReference = dependencyReferences.next();
            if (dependencyReference.isReferencing(event.getSource())) continue;
            dependencyReference = null;
        }
        if (dependencyReference != null) {
            boolean isCurrentlySatisfied = this.areDependenciesSatisfied();
            if (event instanceof LifecycleStartedEvent) {
                this.dependenciesStatus.put(dependencyReference, Status.Started);
                if (isCurrentlySatisfied) {
                    logger.log(Level.WARNING, "DependencyTracker is already satisfied, still a LifeCycleStartedEvent was received {0}: Received Lifecycle Event {1}\n", new Object[]{this.dependentResource, event});
                } else if (this.areDependenciesSatisfied()) {
                    this.dependentResource.onDependenciesSatisfied(this.environment);
                }
            } else if (event instanceof LifecycleStoppedEvent) {
                this.dependenciesStatus.put(dependencyReference, Status.Stopped);
                if (isCurrentlySatisfied) {
                    this.environment.getResource(EventDispatcher.class).dispatchEvent(new LifecycleStoppedEvent<DependentResource>(this.dependentResource));
                    this.dependentResource.onDependenciesViolated(this.environment);
                }
            } else {
                logger.log(Level.WARNING, "DependencyTracker received an unknown LifeCycleEvent for {0}: Received Lifecycle Event {1}\n", new Object[]{this.dependentResource, event});
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dependentResource == null ? 0 : this.dependentResource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyTracker other = (DependencyTracker)obj;
        return !(this.dependentResource == null ? other.dependentResource != null : !this.dependentResource.equals(other.dependentResource));
    }

    private static enum Status {
        Started,
        Stopped;

    }
}

