/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible.namespaces;

import com.oracle.coherence.environment.extensible.AttributeContentHandler;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.ElementContentHandler;
import com.oracle.coherence.environment.extensible.NamespaceContentHandler;
import com.oracle.coherence.environment.extensible.QualifiedName;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;
import java.net.URI;
import java.util.HashMap;

public abstract class AbstractNamespaceContentHandler
implements NamespaceContentHandler,
ElementContentHandler,
AttributeContentHandler {
    private String prefix;
    private HashMap<String, ElementContentHandler> elementContentHandlers = new HashMap();
    private HashMap<String, AttributeContentHandler> attributeContentHandlers = new HashMap();

    public void registerContentHandler(String localName, ElementContentHandler elementContentHandler) {
        this.elementContentHandlers.put(localName, elementContentHandler);
    }

    public void registerContentHandler(String localName, AttributeContentHandler attributeContentHandler) {
        this.attributeContentHandlers.put(localName, attributeContentHandler);
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void onStartScope(ConfigurationContext context, String prefix, URI uri) {
        this.prefix = prefix;
    }

    @Override
    public void onEndScope(ConfigurationContext context, String prefix, URI uri) {
    }

    @Override
    public final Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        if (this.elementContentHandlers.containsKey(qualifiedName.getLocalName())) {
            return this.elementContentHandlers.get(qualifiedName.getLocalName()).onElement(context, qualifiedName, xmlElement);
        }
        return this.onUnknownElement(context, qualifiedName, xmlElement);
    }

    public Object onUnknownElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        throw new ConfigurationException(String.format("The NamespaceContentHandler [%s] can't process the element [%s] as it is unknown.", this.getClass().getName(), xmlElement), String.format("Please consult the documentation for the declared %s namespace", this.getPrefix()));
    }

    @Override
    public final void onAttribute(ConfigurationContext context, QualifiedName qualifiedName, XmlValue xmlValue) throws ConfigurationException {
        if (this.attributeContentHandlers.containsKey(qualifiedName.getLocalName())) {
            this.attributeContentHandlers.get(qualifiedName.getLocalName()).onAttribute(context, qualifiedName, xmlValue);
        } else {
            this.onUnknownAttribute(context, qualifiedName, xmlValue);
        }
    }

    public final void onUnknownAttribute(ConfigurationContext context, QualifiedName qualifiedName, XmlValue xmlValue) throws ConfigurationException {
    }
}

