/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible.namespaces;

import com.oracle.coherence.common.builders.BuilderRegistry;
import com.oracle.coherence.common.builders.ClassSchemeBasedParameterizedBuilder;
import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.common.builders.StaticFactoryClassSchemeBasedParameterizedBuilder;
import com.oracle.coherence.common.util.Value;
import com.oracle.coherence.configuration.caching.CacheMapping;
import com.oracle.coherence.configuration.caching.CacheMappingRegistry;
import com.oracle.coherence.configuration.expressions.Constant;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.parameters.Parameter;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.oracle.coherence.configuration.parameters.SimpleParameterProvider;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.ElementContentHandler;
import com.oracle.coherence.environment.extensible.QualifiedName;
import com.oracle.coherence.environment.extensible.namespaces.AbstractNamespaceContentHandler;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.UUID;
import java.io.File;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoherenceNamespaceContentHandler
extends AbstractNamespaceContentHandler {
    private static final Logger logger = Logger.getLogger(CoherenceNamespaceContentHandler.class.getName());
    private LinkedHashMap<String, XmlElement> cacheSchemeMappings = new LinkedHashMap();
    private LinkedHashMap<String, XmlElement> cachingSchemes = new LinkedHashMap();
    private LinkedHashMap<String, XmlElement> defaults = new LinkedHashMap();

    public CoherenceNamespaceContentHandler() {
        this.registerContentHandler("class-scheme", new ElementContentHandler(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                void var4_8;
                if (xmlElement.getElementList().size() == 1 && !new QualifiedName((XmlElement)xmlElement.getElementList().get(0)).getPrefix().equals(CoherenceNamespaceContentHandler.this.getPrefix())) {
                    Object processed = context.processOnlyElementOf(xmlElement);
                    if (!(processed instanceof ParameterizedBuilder)) throw new ConfigurationException(String.format("The element %s can't be used within a <class-scheme> as the associated namespace handler doesnt return a ClassScheme for the element.", xmlElement.getElementList().get(0)), "Please ensure that the namespace handler for the element constructs a ClassScheme for the element.");
                    ParameterizedBuilder parameterizedBuilder = (ParameterizedBuilder)processed;
                    String id = new UUID().toString();
                    xmlElement.addAttribute("use-scheme").setString(id);
                    context.getEnvironment().getResource(BuilderRegistry.class).registerBuilder(id, parameterizedBuilder);
                    return var4_8;
                } else if (xmlElement.getElement(new QualifiedName(qualifiedName.getPrefix(), "class-factory-name").getName()) == null) {
                    ClassSchemeBasedParameterizedBuilder classSchemeBasedParameterizedBuilder = new ClassSchemeBasedParameterizedBuilder();
                    context.configure(classSchemeBasedParameterizedBuilder, qualifiedName, xmlElement);
                    return var4_8;
                } else {
                    StaticFactoryClassSchemeBasedParameterizedBuilder staticFactoryClassSchemeBasedParameterizedBuilder = new StaticFactoryClassSchemeBasedParameterizedBuilder();
                    context.configure(staticFactoryClassSchemeBasedParameterizedBuilder, qualifiedName, xmlElement);
                }
                return var4_8;
            }
        });
        this.registerContentHandler("cache-mapping", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                CoherenceNamespaceContentHandler.this.cacheSchemeMappings.put(xmlElement.getElement("cache-name").getString(""), xmlElement);
                String cacheName = context.getMandatoryProperty("cache-name", String.class, qualifiedName, xmlElement);
                String schemeName = context.getMandatoryProperty("scheme-name", String.class, qualifiedName, xmlElement);
                ParameterProvider parameterProvider = context.getOptionalProperty("init-params", ParameterProvider.class, SystemPropertyParameterProvider.INSTANCE, qualifiedName, xmlElement);
                CacheMapping cacheMapping = new CacheMapping(cacheName, schemeName, parameterProvider);
                context.getEnvironment().getResource(CacheMappingRegistry.class).addCacheMapping(cacheMapping);
                context.processElementsOf(xmlElement, new QualifiedName[0]);
                return cacheMapping;
            }
        });
        this.registerContentHandler("caching-schemes", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                context.processElementsOf(xmlElement, new QualifiedName[0]);
                for (XmlElement xmlSchemeElement : xmlElement.getElementList()) {
                    XmlElement schemeNameElement = xmlSchemeElement.getElement("scheme-name");
                    String schemeName = schemeNameElement == null ? new UUID().toString() : schemeNameElement.getString();
                    CoherenceNamespaceContentHandler.this.cachingSchemes.put(schemeName, xmlSchemeElement);
                }
                return null;
            }
        });
        this.registerContentHandler("defaults", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                for (XmlElement childElement : xmlElement.getElementList()) {
                    if (CoherenceNamespaceContentHandler.this.defaults.containsKey(childElement.getName())) {
                        logger.log(Level.WARNING, "WARNING: Overriding existing <defaults> definition for {0} with {1}", new Object[]{childElement.getName(), childElement.toString()});
                    }
                    context.processElement(childElement);
                    CoherenceNamespaceContentHandler.this.defaults.put(childElement.getName(), childElement);
                }
                return null;
            }
        });
        this.registerContentHandler("init-param", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                String name = context.getOptionalProperty("param-name", String.class, new UUID().toString(), qualifiedName, xmlElement);
                String className = context.processElementOf(xmlElement, new QualifiedName(CoherenceNamespaceContentHandler.this.getPrefix(), "param-type"), null);
                final Expression expression = XmlElement.class.getName().equals(className) ? new Constant(xmlElement.getElement("param-value")) : context.getMandatoryProperty("param-value", Expression.class, qualifiedName, xmlElement);
                final ClassLoader classLoader = context.getClassLoader();
                if (className != null && className.trim().equals("{cache-ref}")) {
                    return new Parameter(name, NamedCache.class.getName(), new Expression(){

                        @Override
                        public Value evaluate(ParameterProvider parameterProvider) {
                            return new Value(CacheFactory.getCache((String)expression.evaluate(parameterProvider).getString(), (ClassLoader)classLoader));
                        }

                        @Override
                        public boolean isSerializable() {
                            return false;
                        }
                    });
                }
                return new Parameter(name, className, expression);
            }
        });
        this.registerContentHandler("init-params", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                SimpleParameterProvider parameterProvider = new SimpleParameterProvider();
                for (XmlElement childElement : xmlElement.getElementList()) {
                    Object childResult = context.processElement(childElement);
                    if (childResult != null && childResult instanceof Parameter) {
                        parameterProvider.addParameter((Parameter)childResult);
                        continue;
                    }
                    return new ConfigurationException(String.format("Invalid parameter definition '%s' in '%s'", childElement, xmlElement), "Please ensure the parameter is correctly defined");
                }
                return parameterProvider;
            }
        });
        this.registerContentHandler("param-type", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                String className = xmlElement.getString();
                if (className.equalsIgnoreCase("string")) {
                    return String.class.getName();
                }
                if (className.equalsIgnoreCase("boolean")) {
                    return Boolean.class.getName();
                }
                if (className.equalsIgnoreCase("int")) {
                    return Integer.class.getName();
                }
                if (className.equalsIgnoreCase("long")) {
                    return Long.class.getName();
                }
                if (className.equalsIgnoreCase("double")) {
                    return Double.class.getName();
                }
                if (className.equalsIgnoreCase("decimal")) {
                    return BigDecimal.class.getName();
                }
                if (className.equalsIgnoreCase("file")) {
                    return File.class.getName();
                }
                if (className.equalsIgnoreCase("date")) {
                    return Date.class.getName();
                }
                if (className.equalsIgnoreCase("time")) {
                    return Time.class.getName();
                }
                if (className.equalsIgnoreCase("datetime")) {
                    return Timestamp.class.getName();
                }
                if (className.equalsIgnoreCase("xml")) {
                    return XmlElement.class.getName();
                }
                if (className.equalsIgnoreCase("classloader") || className.equalsIgnoreCase("java.lang.ClassLoader")) {
                    return ClassLoader.class.getName();
                }
                return className;
            }
        });
    }

    @Override
    public Object onUnknownElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
        return context.processElementsOf(xmlElement, new QualifiedName[0]);
    }

    @Override
    public void onStartScope(ConfigurationContext context, String prefix, URI uri) {
        super.onStartScope(context, prefix, uri);
        context.getEnvironment().registerResource(CacheMappingRegistry.class, new CacheMappingRegistry());
    }

    public void build(StringBuilder builder) {
        builder.append("<cache-config>\n");
        if (!this.defaults.isEmpty()) {
            builder.append("   <defaults>\n");
            for (String name : this.defaults.keySet()) {
                this.build(builder, this.defaults.get(name), 2);
            }
            builder.append("   </defaults>\n");
        }
        builder.append("   <caching-scheme-mapping>\n");
        for (String cacheName : this.cacheSchemeMappings.keySet()) {
            this.build(builder, this.cacheSchemeMappings.get(cacheName), 2);
        }
        builder.append("   </caching-scheme-mapping>\n");
        builder.append("\n");
        builder.append("   <caching-schemes>\n");
        for (String schemeName : this.cachingSchemes.keySet()) {
            this.build(builder, this.cachingSchemes.get(schemeName), 2);
        }
        builder.append("   </caching-schemes>\n");
        builder.append("</cache-config>\n");
    }

    private void build(StringBuilder builder, XmlElement xmlElement, int indent) {
        String padding = Base.dup((char)' ', (int)(indent * 4));
        builder.append(padding);
        builder.append("<");
        builder.append(xmlElement.getName());
        for (String attributeName : xmlElement.getAttributeMap().keySet()) {
            builder.append(" ");
            builder.append(attributeName);
            builder.append("=\"");
            builder.append(xmlElement.getAttribute(attributeName).toString());
            builder.append("\"");
        }
        if (xmlElement.getString("").trim().length() > 0) {
            builder.append(">");
            builder.append(xmlElement.getString("").trim());
            builder.append("</");
            builder.append(xmlElement.getName());
            builder.append(">\n");
        } else if (xmlElement.getElementList().size() == 0 && xmlElement.getString("").trim().length() == 0) {
            builder.append("/>\n");
        } else {
            builder.append(">\n");
            for (XmlElement xml : xmlElement.getElementList()) {
                this.build(builder, xml, indent + 1);
            }
            if (xmlElement.getString("").length() == 0) {
                builder.append(padding);
            }
            builder.append("</");
            builder.append(xmlElement.getName());
            builder.append(">\n");
        }
    }

    public boolean isCacheNameDefined(String cacheName) {
        return this.cacheSchemeMappings.containsKey(cacheName);
    }

    public boolean isSchemeNameDefined(String schemeName) {
        return this.cachingSchemes.containsKey(schemeName);
    }
}

