/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible.namespaces;

import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.ElementContentHandler;
import com.oracle.coherence.environment.extensible.QualifiedName;
import com.oracle.coherence.environment.extensible.namespaces.AbstractNamespaceContentHandler;
import com.tangosol.run.xml.XmlElement;

public class EnvironmentNamespaceContentHandler
extends AbstractNamespaceContentHandler {
    public EnvironmentNamespaceContentHandler() {
        this.registerContentHandler("instance", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                return context.getEnvironment();
            }
        });
        this.registerContentHandler("resource", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                String name = xmlElement.getAttribute("id").getString();
                XmlElement childElement = (XmlElement)xmlElement.getElementList().get(0);
                if (childElement == null) {
                    throw new ConfigurationException(String.format("Expected child element of [%s] to construct a ClassScheme resource for the environment.", xmlElement), "Please consult the documentation for the Environment namespace");
                }
                Object objectToRegister = context.processElement(childElement);
                try {
                    if (objectToRegister instanceof ParameterizedBuilder) {
                        objectToRegister = ((ParameterizedBuilder)objectToRegister).realize(SystemPropertyParameterProvider.INSTANCE);
                    }
                    context.getEnvironment().registerResource(Class.forName(name), objectToRegister);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ConfigurationException(String.format("The class/interface name [%s] specified in the <%s:resource> element is unknown.", name, EnvironmentNamespaceContentHandler.this.getPrefix()), "Please ensure the class is on the classpath and/or the classname is correct", classNotFoundException);
                }
                return objectToRegister;
            }
        });
        this.registerContentHandler("ref", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                String name = xmlElement.getAttribute("id").getString();
                try {
                    return context.getEnvironment().getResource(Class.forName(name));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ConfigurationException(String.format("The class/interface name [%s] specified in the <%s:ref> element is unknown", name, EnvironmentNamespaceContentHandler.this.getPrefix()), "Please ensure the class is on the classpath and/or the classname is correct", classNotFoundException);
                }
            }
        });
    }
}

