/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible.namespaces;

import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.ElementContentHandler;
import com.oracle.coherence.environment.extensible.QualifiedName;
import com.oracle.coherence.environment.extensible.namespaces.AbstractNamespaceContentHandler;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Filter;
import com.tangosol.util.QueryHelper;
import com.tangosol.util.filter.AllFilter;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.AnyFilter;
import com.tangosol.util.filter.ArrayFilter;
import com.tangosol.util.filter.NeverFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.OrFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.filter.XorFilter;
import java.util.Map;

public class FilterNamespaceContentHandler
extends AbstractNamespaceContentHandler {
    public FilterNamespaceContentHandler() {
        this.registerContentHandler("custom", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                Object result = context.processOnlyElementOf(xmlElement);
                if (result != null && result instanceof ParameterizedBuilder && ((ParameterizedBuilder)result).realizesClassOf(Filter.class, SystemPropertyParameterProvider.INSTANCE)) {
                    return ((ParameterizedBuilder)result).realize(SystemPropertyParameterProvider.INSTANCE);
                }
                throw new ConfigurationException(String.format("The filter specified in %s does not implement Filter", xmlElement), "Please consult the documentation regarding use of the Filter namespace");
            }
        });
        this.registerContentHandler("where", new WhereFilterElementContentHandler());
        this.registerContentHandler("not", new NotFilterElementContentHandler());
        this.registerContentHandler("always", new EmptyFilterElementContentHandler((Filter)AlwaysFilter.INSTANCE));
        this.registerContentHandler("never", new EmptyFilterElementContentHandler((Filter)NeverFilter.INSTANCE));
        this.registerContentHandler("present", new EmptyFilterElementContentHandler((Filter)PresentFilter.INSTANCE));
        this.registerContentHandler("all", new ArrayFilterElementContentHandler<AllFilter>(AllFilter.class));
        this.registerContentHandler("any", new ArrayFilterElementContentHandler<AnyFilter>(AnyFilter.class));
        this.registerContentHandler("and", new LogicFilterElementContentHandler<AndFilter>(AndFilter.class));
        this.registerContentHandler("or", new LogicFilterElementContentHandler<OrFilter>(OrFilter.class));
        this.registerContentHandler("xor", new LogicFilterElementContentHandler<XorFilter>(XorFilter.class));
    }

    static class WhereFilterElementContentHandler
    implements ElementContentHandler {
        WhereFilterElementContentHandler() {
        }

        @Override
        public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
            String expression = xmlElement.getString("");
            try {
                return QueryHelper.createFilter((String)expression);
            }
            catch (RuntimeException e) {
                throw new ConfigurationException("Failed to create a Filter from the where clause:" + xmlElement, "Please ensure that the where clause is syntactically correct", e);
            }
        }
    }

    static class NotFilterElementContentHandler
    implements ElementContentHandler {
        NotFilterElementContentHandler() {
        }

        @Override
        public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
            Object oFilter = context.processOnlyElementOf(xmlElement);
            if (oFilter instanceof Filter) {
                return new NotFilter((Filter)oFilter);
            }
            throw new ConfigurationException("Expected a Filter definition in: " + xmlElement, "Please ensure a Filter is defined");
        }
    }

    static class LogicFilterElementContentHandler<T extends ArrayFilter>
    implements ElementContentHandler {
        private Class<T> filter;

        public LogicFilterElementContentHandler(Class<T> filter) {
            this.filter = filter;
        }

        @Override
        public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
            Map<String, Filter> mapFilters = context.processElementsOf(xmlElement, Filter.class);
            if (mapFilters.size() == 2) {
                Filter[] filters = new Filter[mapFilters.size()];
                int i = 0;
                for (Filter filter : mapFilters.values()) {
                    filters[i++] = filter;
                }
                try {
                    return this.filter.getConstructor(Filter.class, Filter.class).newInstance(filters[0], filters[1]);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Can't create a filter with the provided filters in " + xmlElement, "Please ensure that all of the child elements are filters", e);
                }
            }
            throw new ConfigurationException("Two filters are required for " + xmlElement, "Please ensure that the correct number of filters are defined");
        }
    }

    static class EmptyFilterElementContentHandler
    implements ElementContentHandler {
        private Filter filter;

        EmptyFilterElementContentHandler(Filter filter) {
            this.filter = filter;
        }

        @Override
        public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
            return this.filter;
        }
    }

    static class ArrayFilterElementContentHandler<T extends ArrayFilter>
    implements ElementContentHandler {
        private Class<T> filter;

        ArrayFilterElementContentHandler(Class<T> filter) {
            this.filter = filter;
        }

        @Override
        public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
            Map<String, Filter> mapFilters = context.processElementsOf(xmlElement, Filter.class);
            Filter[] filters = new Filter[mapFilters.size()];
            int i = 0;
            for (Filter filter : mapFilters.values()) {
                filters[i++] = filter;
            }
            try {
                return this.filter.getConstructor(Filter[].class).newInstance(new Object[]{filters});
            }
            catch (Exception e) {
                throw new ConfigurationException("Can't create a filter with the provided filters in " + xmlElement, "Please ensure that all of the child elements are filters", e);
            }
        }
    }
}

