/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible.namespaces;

import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.configuration.caching.CacheMapping;
import com.oracle.coherence.configuration.caching.CacheMappingRegistry;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.ElementContentHandler;
import com.oracle.coherence.environment.extensible.QualifiedName;
import com.oracle.coherence.environment.extensible.namespaces.AbstractNamespaceContentHandler;
import com.tangosol.run.xml.XmlElement;

public class ServerNamespaceContentHandler
extends AbstractNamespaceContentHandler {
    public ServerNamespaceContentHandler() {
        this.registerContentHandler("backingmap-event-processor", new ElementContentHandler(){

            @Override
            public Object onElement(ConfigurationContext context, QualifiedName qualifiedName, XmlElement xmlElement) throws ConfigurationException {
                String cacheName = ServerNamespaceContentHandler.this.getSourceCacheName(xmlElement);
                CacheMapping cacheMapping = context.getEnvironment().getResource(CacheMappingRegistry.class).findCacheMapping(cacheName);
                ParameterizedBuilder builder = (ParameterizedBuilder)context.processOnlyElementOf(xmlElement);
                cacheMapping.addEnrichment(ParameterizedBuilder.class, "event-processor", builder);
                return builder;
            }
        });
    }

    private String getSourceCacheName(XmlElement cacheEventProcessorElement) throws ConfigurationException {
        if (cacheEventProcessorElement.getParent() != null && new QualifiedName(cacheEventProcessorElement.getParent()).getLocalName().equals("cache-mapping")) {
            XmlElement cacheNameElement = cacheEventProcessorElement.getParent().findElement("cache-name");
            if (cacheNameElement == null) {
                throw new ConfigurationException(String.format("The element %s is missing a <cache-name> element declaration", cacheEventProcessorElement.getParent()), "Please consult the documentation on how to use the BackingMapEventProcessor namespace");
            }
            return cacheNameElement.getString();
        }
        throw new ConfigurationException(String.format("Missing 'cache-name' declaration for the cache-backingmap-event-processor %s", cacheEventProcessorElement), "The cache-backingmap-event-processor declaration should either inside a <cache-mapping> element or declare a 'cache-name' attribute.");
    }
}

