/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.environment.extensible.namespaces;

import com.oracle.coherence.configuration.expressions.MacroParameterExpression;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.oracle.coherence.environment.extensible.AttributeContentHandler;
import com.oracle.coherence.environment.extensible.ConfigurationContext;
import com.oracle.coherence.environment.extensible.ConfigurationException;
import com.oracle.coherence.environment.extensible.QualifiedName;
import com.oracle.coherence.environment.extensible.namespaces.AbstractNamespaceContentHandler;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import java.util.HashSet;

public class XmlElementProcessingNamespaceContentHandler
extends AbstractNamespaceContentHandler {
    private HashSet<String> introducedUris = new HashSet();

    public XmlElementProcessingNamespaceContentHandler() {
        this.registerContentHandler("introduce-cache-config", new AttributeContentHandler(){

            @Override
            public void onAttribute(ConfigurationContext context, QualifiedName qualifiedName, XmlValue xmlValue) throws ConfigurationException {
                if (xmlValue.getParent().getName().equals("cache-config")) {
                    String[] uris;
                    for (String uri : uris = xmlValue.getString().split(",")) {
                        String string = uri = uri == null ? "" : uri.trim();
                        if (uri.isEmpty()) continue;
                        uri = new MacroParameterExpression(uri).evaluate(SystemPropertyParameterProvider.INSTANCE).getString().trim();
                        if (XmlElementProcessingNamespaceContentHandler.this.introducedUris.contains(uri)) continue;
                        XmlDocument document = DefaultConfigurableCacheFactory.loadConfigAsResource((String)uri, (ClassLoader)context.getClassLoader());
                        XmlElementProcessingNamespaceContentHandler.this.introducedUris.add(uri);
                        context.processDocument((XmlElement)document);
                    }
                } else {
                    throw new ConfigurationException(String.format("Attempted to use an %s in a non-<cache-config> element", qualifiedName), "The introduce-cache-config attribute is only applicable to <cache-config> elements.");
                }
            }
        });
        this.registerContentHandler("replace-with-file", new AttributeContentHandler(){

            @Override
            public void onAttribute(ConfigurationContext context, QualifiedName qualifiedName, XmlValue xmlValue) throws ConfigurationException {
                XmlElement xmlElement = xmlValue.getParent();
                MacroParameterExpression exprUri = new MacroParameterExpression(xmlValue.getString());
                String uri = exprUri.evaluate(SystemPropertyParameterProvider.INSTANCE).getString();
                XmlDocument rootElement = XmlHelper.loadFileOrResource((String)uri, (String)"replace-with-file", (ClassLoader)context.getClassLoader());
                XmlHelper.replaceSystemProperties((XmlElement)rootElement, (String)"system-property");
                if (xmlElement.getName().equals(rootElement.getName())) {
                    for (XmlElement childElement : xmlElement.getElementList()) {
                        XmlHelper.replaceElement((XmlElement)xmlElement, (XmlElement)childElement);
                    }
                } else {
                    throw new ConfigurationException(String.format("The root element <%s> of the file [%s] is not a <%s> element as expected in [%s]", rootElement.getRoot().getName(), uri, xmlElement.getName(), xmlElement.getParent()), "To replace an element with a file, the element and root element of the file must be the same type");
                }
                XmlHelper.addElements((XmlElement)xmlElement, rootElement.getElementList().iterator());
            }
        });
    }
}

