/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring;

import com.tangosol.config.expression.ExpressionParser;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateAwareExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class CoherenceBeanExpressionResolver
extends StandardBeanExpressionResolver {
    private final ThreadLocal<ParameterResolver> m_tlResolver = new ThreadLocal<ParameterResolver>(){

        @Override
        protected ParameterResolver initialValue() {
            return new NullParameterResolver();
        }
    };

    public CoherenceBeanExpressionResolver(ExpressionParser exprParser) {
        this.setExpressionParser((org.springframework.expression.ExpressionParser)new CoherenceExpressionParser(exprParser));
    }

    protected void customizeEvaluationContext(StandardEvaluationContext evalContext) {
        evalContext.setVariable("resolver", (Object)this.getResolver());
    }

    public ParameterResolver getResolver() {
        return this.m_tlResolver.get();
    }

    public void setParameterResolver(ParameterResolver resolver) {
        this.m_tlResolver.set(resolver);
    }

    private class CoherenceExpressionParser
    extends TemplateAwareExpressionParser {
        private ExpressionParser m_exprParserCoh;
        private org.springframework.expression.ExpressionParser m_exprParserSpring;

        public CoherenceExpressionParser(ExpressionParser exprParserCoh) {
            this(exprParserCoh, (org.springframework.expression.ExpressionParser)new SpelExpressionParser());
        }

        public CoherenceExpressionParser(ExpressionParser exprParserCoh, org.springframework.expression.ExpressionParser exprParserSpring) {
            this.m_exprParserCoh = exprParserCoh;
            this.m_exprParserSpring = exprParserSpring;
        }

        protected Expression doParseExpression(String sExpression, ParserContext context) throws ParseException {
            sExpression = sExpression == null ? "" : sExpression.trim();
            return new DelegatingExpression("{" + sExpression + "}", this.m_exprParserSpring.parseExpression("#{" + sExpression + "}", context));
        }

        private class DelegatingExpression
        implements Expression {
            private String m_sExpression;
            private Expression m_exprSpring;

            public DelegatingExpression(String sExpression, Expression exprSpring) {
                this.m_sExpression = sExpression;
                this.m_exprSpring = exprSpring;
            }

            public Object getValue() throws EvaluationException {
                Object oValue = this.evaluate(Object.class);
                if (oValue == null) {
                    oValue = this.m_exprSpring.getValue();
                }
                return oValue;
            }

            public Object getValue(Object rootObject) throws EvaluationException {
                Object oValue = this.evaluate(Object.class);
                if (oValue == null) {
                    oValue = this.m_exprSpring.getValue(rootObject);
                }
                return oValue;
            }

            public <T> T getValue(Class<T> desiredResultType) throws EvaluationException {
                Object value = this.evaluate(desiredResultType);
                if (value == null) {
                    value = this.m_exprSpring.getValue(desiredResultType);
                }
                return value;
            }

            public <T> T getValue(Object rootObject, Class<T> desiredResultType) throws EvaluationException {
                Object value = this.evaluate(desiredResultType);
                if (value == null) {
                    value = this.m_exprSpring.getValue(rootObject, desiredResultType);
                }
                return value;
            }

            public Object getValue(EvaluationContext context) throws EvaluationException {
                Object oValue = this.evaluate(Object.class, this.getParamResolver(context));
                if (oValue == null) {
                    oValue = this.m_exprSpring.getValue(context);
                }
                return oValue;
            }

            public Object getValue(EvaluationContext context, Object rootObject) throws EvaluationException {
                Object oValue = this.evaluate(Object.class, this.getParamResolver(context));
                if (oValue == null) {
                    oValue = this.m_exprSpring.getValue(context, rootObject);
                }
                return oValue;
            }

            public <T> T getValue(EvaluationContext context, Class<T> desiredResultType) throws EvaluationException {
                Object value = this.evaluate(desiredResultType, this.getParamResolver(context));
                if (value == null) {
                    value = this.m_exprSpring.getValue(context, desiredResultType);
                }
                return value;
            }

            public <T> T getValue(EvaluationContext context, Object rootObject, Class<T> desiredResultType) throws EvaluationException {
                Object value = this.evaluate(desiredResultType, this.getParamResolver(context));
                if (value == null) {
                    value = this.m_exprSpring.getValue(context, rootObject, desiredResultType);
                }
                return value;
            }

            public Class getValueType() throws EvaluationException {
                return Object.class;
            }

            public Class getValueType(Object rootObject) throws EvaluationException {
                return this.getValueType();
            }

            public Class getValueType(EvaluationContext context) throws EvaluationException {
                return this.getValueType();
            }

            public Class getValueType(EvaluationContext context, Object rootObject) throws EvaluationException {
                return this.getValueType();
            }

            public TypeDescriptor getValueTypeDescriptor() throws EvaluationException {
                return TypeDescriptor.valueOf(Object.class);
            }

            public TypeDescriptor getValueTypeDescriptor(Object rootObject) throws EvaluationException {
                return this.getValueTypeDescriptor();
            }

            public TypeDescriptor getValueTypeDescriptor(EvaluationContext context) throws EvaluationException {
                return this.getValueTypeDescriptor();
            }

            public TypeDescriptor getValueTypeDescriptor(EvaluationContext context, Object rootObject) throws EvaluationException {
                return this.getValueTypeDescriptor();
            }

            public boolean isWritable(EvaluationContext context) throws EvaluationException {
                return false;
            }

            public boolean isWritable(EvaluationContext context, Object rootObject) throws EvaluationException {
                return false;
            }

            public boolean isWritable(Object rootObject) throws EvaluationException {
                return false;
            }

            public void setValue(EvaluationContext context, Object value) throws EvaluationException {
            }

            public void setValue(Object rootObject, Object value) throws EvaluationException {
            }

            public void setValue(EvaluationContext context, Object rootObject, Object value) throws EvaluationException {
            }

            public String getExpressionString() {
                return this.m_sExpression;
            }

            protected ParameterResolver getParamResolver(EvaluationContext ctx) {
                Object oResolver;
                ParameterResolver resolver = CoherenceBeanExpressionResolver.this.getResolver();
                if (resolver == null && (oResolver = ctx.lookupVariable("resolver")) instanceof ParameterResolver) {
                    resolver = (ParameterResolver)oResolver;
                }
                return resolver;
            }

            protected <T> T evaluate(Class<T> clzDestined) {
                return this.evaluate(clzDestined, CoherenceBeanExpressionResolver.this.getResolver());
            }

            protected <T> T evaluate(Class<T> clzDestined, ParameterResolver resolver) {
                try {
                    return (T)CoherenceExpressionParser.this.m_exprParserCoh.parse(this.m_sExpression, clzDestined).evaluate(resolver);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
    }
}

