/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring;

import com.oracle.coherence.spring.CoherenceBeanExpressionResolver;
import com.tangosol.coherence.config.ParameterMacroExpressionParser;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.util.ResourceRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;

public class SpringBasedCoherenceSession
implements ApplicationContextAware,
ApplicationListener<ApplicationContextEvent> {
    private static final String DEFAULT_CACHE_CONFIG_URI = "$Default$";
    private ApplicationContext applicationContext = null;
    private ExtensibleConfigurableCacheFactory configurableCacheFactory = null;
    private String cacheConfigURI;

    public SpringBasedCoherenceSession() {
        this(DEFAULT_CACHE_CONFIG_URI);
    }

    public SpringBasedCoherenceSession(String cacheConfigURI) {
        this.cacheConfigURI = cacheConfigURI;
    }

    public NamedCache getCache(String name) {
        return this.configurableCacheFactory.ensureCache(name, null);
    }

    public Service getService(String name) {
        return this.configurableCacheFactory.ensureService(name);
    }

    public ResourceRegistry getResourceRegistry() {
        return this.configurableCacheFactory.getResourceRegistry();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)beanFactory).setBeanExpressionResolver((BeanExpressionResolver)new CoherenceBeanExpressionResolver(ParameterMacroExpressionParser.INSTANCE));
        }
        ExtensibleConfigurableCacheFactory.Dependencies dependencies = this.cacheConfigURI.equals(DEFAULT_CACHE_CONFIG_URI) ? ExtensibleConfigurableCacheFactory.DependenciesHelper.newInstance() : ExtensibleConfigurableCacheFactory.DependenciesHelper.newInstance((String)this.cacheConfigURI);
        dependencies.getResourceRegistry().registerResource(ApplicationContext.class, (Object)applicationContext);
        dependencies.getResourceRegistry().registerResource(BeanFactory.class, (Object)applicationContext);
        this.configurableCacheFactory = new ExtensibleConfigurableCacheFactory(dependencies);
        CacheFactory.getCacheFactoryBuilder().setConfigurableCacheFactory((ConfigurableCacheFactory)this.configurableCacheFactory, this.cacheConfigURI, null, false);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (!(event instanceof ContextRefreshedEvent)) {
            if (event instanceof ContextStartedEvent) {
                this.configurableCacheFactory.activate();
            } else if (event instanceof ContextStoppedEvent) {
                this.configurableCacheFactory.dispose();
                CacheFactory.getCacheFactoryBuilder().release((ConfigurableCacheFactory)this.configurableCacheFactory);
                this.configurableCacheFactory = null;
            }
        }
    }
}

