/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.spring;

import com.oracle.coherence.spring.CoherenceBeanExpressionResolver;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.ExpressionParser;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.xml.AbstractNamespaceHandler;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.run.xml.QualifiedName;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Builder;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.Resources;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringNamespaceHandler
extends AbstractNamespaceHandler {
    public SpringNamespaceHandler() {
        this.registerProcessor("bean-factory", (ElementProcessor)new ElementProcessor<Void>(){

            public Void process(ProcessingContext context, XmlElement element) throws ConfigurationException {
                ResourceRegistry registry = context.getResourceRegistry();
                SpringBeanFactoryBuilder bldr = (SpringBeanFactoryBuilder)context.inject((Object)new SpringBeanFactoryBuilder(registry, context.getExpressionParser()), element);
                registry.registerResource(SpringBeanFactoryBuilder.class, SpringNamespaceHandler.getFactoryNameAsString(SpringBeanFactoryBuilder.class, bldr.getFactoryName(), context.getDefaultParameterResolver()), (Object)bldr);
                return null;
            }
        });
        this.registerProcessor("bean", (ElementProcessor)new ElementProcessor<SpringBeanBuilder>(){

            public SpringBeanBuilder process(ProcessingContext context, XmlElement element) throws ConfigurationException {
                SpringBeanBuilder bldr = new SpringBeanBuilder(context.getResourceRegistry());
                context.inject((Object)bldr, element);
                SimpleParameterList listParam = new SimpleParameterList();
                String sPrefix = element.getQualifiedName().getPrefix();
                for (XmlElement e : element.getElementList()) {
                    QualifiedName qName = e.getQualifiedName();
                    if (!Base.equals((Object)sPrefix, (Object)qName.getPrefix()) || !qName.getLocalName().equals("property")) continue;
                    listParam.add(context.processElement(e));
                }
                bldr.setParameterList((ParameterList)listParam);
                return bldr;
            }
        });
    }

    protected static String getFactoryNameAsString(Class<?> factoryClass, Expression<String> exprFactoryName, ParameterResolver resolver) {
        return exprFactoryName == null ? factoryClass.getName() : (String)exprFactoryName.evaluate(resolver);
    }

    public static class SpringBeanFactoryBuilder
    implements ParameterizedBuilder<BeanFactory>,
    ParameterizedBuilder.ReflectionSupport {
        private ResourceRegistry m_registry;
        private Expression<String> m_exprAppCtxUri;
        private Expression<String> m_exprFactoryName;
        private ExpressionParser m_exprParser;

        public SpringBeanFactoryBuilder(ResourceRegistry registry, ExpressionParser exprParser) {
            this.m_registry = registry;
            this.m_exprParser = exprParser;
        }

        public Expression<String> getFactoryName() {
            return this.m_exprFactoryName;
        }

        @Injectable
        public void setFactoryName(Expression<String> exprFactoryName) {
            this.m_exprFactoryName = exprFactoryName;
        }

        public Expression<String> getApplicationContextUri() {
            return this.m_exprAppCtxUri;
        }

        @Injectable
        public void setApplicationContextUri(Expression<String> exprAppCtxUri) {
            this.m_exprAppCtxUri = exprAppCtxUri;
        }

        public boolean realizes(Class<?> clzClass, ParameterResolver resolver, ClassLoader loader) {
            return BeanFactory.class.isAssignableFrom(clzClass);
        }

        public BeanFactory realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            ResourceRegistry registry = this.m_registry;
            String sFactoryName = SpringNamespaceHandler.getFactoryNameAsString(BeanFactory.class, this.getFactoryName(), resolver);
            BeanFactory factory = (BeanFactory)registry.getResource(BeanFactory.class, sFactoryName);
            if (factory == null) {
                Expression<String> exprAppCtxUri = this.getApplicationContextUri();
                if (exprAppCtxUri == null) {
                    throw new ConfigurationException("Missing parameter <application-context-uri>", "Ensure that parameter <application-context-uri> is supplied");
                }
                String sAppCtx = (String)exprAppCtxUri.evaluate(resolver);
                final URL url = Resources.findFileOrResource((String)sAppCtx, (ClassLoader)loader);
                if (url == null) {
                    throw new ConfigurationException(String.format("Resource '%s' not found for bean factory '%s'", sAppCtx, sFactoryName), "Ensure that <application-context-uri> contains a valid file location");
                }
                registry.registerResource(BeanFactory.class, sFactoryName, (Builder)new Builder<BeanFactory>(){

                    public BeanFactory realize() {
                        return new CoherenceApplicationContext(url.toExternalForm());
                    }
                }, RegistrationBehavior.IGNORE, (ResourceRegistry.ResourceLifecycleObserver)new ResourceRegistry.ResourceLifecycleObserver<BeanFactory>(){

                    public void onRelease(BeanFactory factory) {
                        if (factory instanceof ConfigurableApplicationContext) {
                            ((ConfigurableApplicationContext)factory).close();
                        }
                    }
                });
                factory = (BeanFactory)registry.getResource(BeanFactory.class, sFactoryName);
            }
            return factory;
        }

        public class CoherenceApplicationContext
        extends FileSystemXmlApplicationContext {
            public CoherenceApplicationContext(String configLocation) throws BeansException {
                super(configLocation);
            }

            protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
                super.prepareBeanFactory(beanFactory);
                beanFactory.setBeanExpressionResolver((BeanExpressionResolver)new CoherenceBeanExpressionResolver(SpringBeanFactoryBuilder.this.m_exprParser));
            }

            public String toString() {
                return ((Object)((Object)this)).getClass().getName() + "; loaded from " + Arrays.asList(super.getConfigLocations());
            }
        }
    }

    public static class SpringBeanBuilder
    implements ParameterizedBuilder<Object>,
    ParameterizedBuilder.ReflectionSupport {
        private ResourceRegistry m_registry;
        private Expression<String> m_exprFactoryName;
        private Expression<String> m_exprBeanName;
        private ParameterList m_listParameters;

        public SpringBeanBuilder(ResourceRegistry registry) {
            this.m_registry = registry;
        }

        public Expression<String> getFactoryName() {
            return this.m_exprFactoryName;
        }

        @Injectable
        public void setFactoryName(Expression<String> exprFactoryName) {
            this.m_exprFactoryName = exprFactoryName;
        }

        public Expression<String> getBeanName() {
            return this.m_exprBeanName;
        }

        @Injectable
        public void setBeanName(Expression<String> exprBeanName) {
            this.m_exprBeanName = exprBeanName;
        }

        public ParameterList getParameterList() {
            return this.m_listParameters;
        }

        public void setParameterList(ParameterList listParameters) {
            this.m_listParameters = listParameters;
        }

        public Object realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            ParameterList listPropParams;
            String sBeanName = (String)this.getBeanName().evaluate(resolver);
            Object oBean = this.ensureBeanFactory(resolver, loader).getBean(sBeanName);
            ParameterList parameterList = listPropParams = listParameters == null ? this.m_listParameters : listParameters;
            if (listPropParams != null) {
                for (Parameter param : listPropParams) {
                    Object oValue = param.evaluate(resolver).get();
                    String sProperty = param.getName();
                    if (sProperty == null || sProperty.isEmpty()) {
                        throw new ConfigurationException("Property element missing \"name\" attribute", "Ensure that bean property elements have a \"name\" attribute (i.e. <property name=\"name\"> ");
                    }
                    String sMethod = "set" + Character.toUpperCase(sProperty.charAt(0)) + sProperty.substring(1);
                    try {
                        ClassHelper.invoke((Object)oBean, (String)sMethod, (Object[])new Object[]{oValue});
                    }
                    catch (Exception e) {
                        throw new ConfigurationException(String.format("Could not invoke '%s' on bean '%s'", sMethod, sBeanName), String.format("Ensure that property '%s' contains a 'set' method on bean '%s'", sProperty, sBeanName), (Throwable)e);
                    }
                }
            }
            return oBean;
        }

        public boolean realizes(Class<?> clzClass, ParameterResolver resolver, ClassLoader loader) {
            String sBeanName = (String)this.getBeanName().evaluate(resolver);
            BeanFactory factory = this.ensureBeanFactory(resolver, loader);
            if (factory.containsBean(sBeanName)) {
                return factory.isTypeMatch(sBeanName, clzClass);
            }
            String sFactory = SpringNamespaceHandler.getFactoryNameAsString(BeanFactory.class, this.getFactoryName(), resolver);
            StringBuilder sbProblem = new StringBuilder();
            sbProblem.append("Spring bean '").append(sBeanName).append("' could not be loaded from bean factory '").append(sFactory).append("' (").append(factory).append(")");
            StringBuilder sbAdvice = new StringBuilder();
            sbAdvice.append("Ensure that a bean name of '").append(sBeanName).append("' exists in bean factory '").append(sFactory).append("'.");
            throw new ConfigurationException(sbProblem.toString(), sbAdvice.toString());
        }

        protected BeanFactory ensureBeanFactory(ParameterResolver resolver, ClassLoader loader) {
            BeanExpressionResolver exprResolver;
            ResourceRegistry registry = this.m_registry;
            String sFactoryName = SpringNamespaceHandler.getFactoryNameAsString(BeanFactory.class, this.getFactoryName(), resolver);
            BeanFactory factory = (BeanFactory)registry.getResource(BeanFactory.class, sFactoryName);
            if (factory == null) {
                sFactoryName = SpringNamespaceHandler.getFactoryNameAsString(SpringBeanFactoryBuilder.class, this.getFactoryName(), resolver);
                SpringBeanFactoryBuilder bldr = (SpringBeanFactoryBuilder)registry.getResource(SpringBeanFactoryBuilder.class, sFactoryName);
                if (bldr == null) {
                    throw new ConfigurationException(String.format("Could not locate bean factory '%s'", sFactoryName), "Ensure that a bean factory is defined in the cache configuration file via<bean-factory> or in the cache factory registry.");
                }
                factory = bldr.realize(resolver, loader, null);
            }
            BeanFactory innerFactory = factory;
            if (factory instanceof ConfigurableApplicationContext) {
                innerFactory = ((ConfigurableApplicationContext)factory).getBeanFactory();
            }
            if (innerFactory instanceof ConfigurableBeanFactory && (exprResolver = ((ConfigurableBeanFactory)innerFactory).getBeanExpressionResolver()) instanceof CoherenceBeanExpressionResolver) {
                ((CoherenceBeanExpressionResolver)exprResolver).setParameterResolver(resolver);
            }
            return factory;
        }
    }

    @XmlSimpleName(value="property")
    public static class PropertyProcessor
    implements ElementProcessor<Parameter> {
        public Parameter process(ProcessingContext context, XmlElement element) throws ConfigurationException {
            String sName = (String)context.getMandatoryProperty("name", String.class, element);
            try {
                return new Parameter(sName, context.getExpressionParser().parse(element.getString(), Object.class));
            }
            catch (ParseException e) {
                throw new ConfigurationException("Error processing <property> element", "Ensure a valid value is present in <property> element", (Throwable)e);
            }
        }
    }
}

