/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import jakarta.json.JsonValue;
import oracle.jdbc.driver.json.binary.JakartaOsonArray;
import oracle.jdbc.driver.json.binary.JakartaOsonObject;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonValueFactory;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.sql.json.OracleJsonDecimal;

public class JakartaOsonValueFactory
extends OsonValueFactory {
    public static JakartaOsonValueFactory INSTANCE = new JakartaOsonValueFactory();

    private JakartaOsonValueFactory() {
    }

    @Override
    Object createBinary(OsonContext osonContext, int n2, int n3, boolean bl) {
        byte[] byArray = new byte[n3];
        osonContext.b.position(n2);
        osonContext.b.get(byArray);
        return new JakartaPrimitive.JakartaBinaryImpl(byArray, bl);
    }

    @Override
    public OsonAbstractArray createArray(OsonContext osonContext, int n2) {
        return new JakartaOsonArray(osonContext, n2);
    }

    @Override
    public OsonAbstractObject createObject(OsonContext osonContext, int n2) {
        return new JakartaOsonObject(osonContext, n2);
    }

    @Override
    public JakartaPrimitive.JakartaStringImpl createString(OsonContext osonContext, int n2, int n3) {
        osonContext.b.position(n2);
        return new JakartaPrimitive.JakartaStringImpl(osonContext.b.readString(n3));
    }

    @Override
    public JakartaPrimitive.JakartaNumberImpl createNumber(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        return new JakartaPrimitive.JakartaNumberImpl(byArray, targetType);
    }

    @Override
    public JakartaPrimitive.JakartaStringNumberImpl createStringNumber(String string) {
        return new JakartaPrimitive.JakartaStringNumberImpl(string);
    }

    @Override
    public JakartaPrimitive.JakartaDoubleImpl createDouble(double d2) {
        return new JakartaPrimitive.JakartaDoubleImpl(d2);
    }

    @Override
    public JakartaPrimitive.JakartaTimestampImpl createTimestamp(byte[] byArray) {
        return new JakartaPrimitive.JakartaTimestampImpl(byArray);
    }

    @Override
    public Object createTimestampTZ(byte[] byArray) {
        return new JakartaPrimitive.JakartaTimestampTZImpl(byArray);
    }

    @Override
    public JakartaPrimitive.JakartaFloatImpl createFloat(float f2) {
        return new JakartaPrimitive.JakartaFloatImpl(f2);
    }

    @Override
    public JakartaPrimitive.JakartaDateImpl createDate(byte[] byArray) {
        return new JakartaPrimitive.JakartaDateImpl(byArray);
    }

    @Override
    public JakartaPrimitive.JakartaIntervalYMImpl createIntervalYM(byte[] byArray) {
        return new JakartaPrimitive.JakartaIntervalYMImpl(byArray);
    }

    @Override
    public JakartaPrimitive.JakartaIntervalDSImpl createIntervalDS(byte[] byArray) {
        return new JakartaPrimitive.JakartaIntervalDSImpl(byArray);
    }

    @Override
    public Object createTrue() {
        return JsonValue.TRUE;
    }

    @Override
    public Object createFalse() {
        return JsonValue.FALSE;
    }

    @Override
    public Object createNull() {
        return JsonValue.NULL;
    }
}

