/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.internal.Monitor;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NLParamParser;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;
import oracle.net.resolver.TNSFile;

public class TNSNamesNamingAdapter
implements NamingAdapterInterface,
Monitor {
    private String tnsDir;
    private long nextPollTime;
    private ArrayList<TNSFile> tnsFiles;
    private static final String TNSFILE = "tnsnames.ora";
    private static final long REFRESH_INTERVAL = 0L;
    private static final int MAX_DEPTH = 5;
    private static final Pattern regexp = Pattern.compile("^(IFILE\\s*=\\s*)(.*)", 2);
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();

    public TNSNamesNamingAdapter(String string) {
        this.tnsDir = string;
        this.resetAttr();
    }

    private void resetAttr() {
        this.tnsFiles = new ArrayList(3);
        this.nextPollTime = 0L;
    }

    @Override
    public String resolve(String string) throws NetException {
        NVPair nVPair = null;
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.checkAndReload();
            for (TNSFile tNSFile : this.tnsFiles) {
                nVPair = tNSFile.getEntries().getNLPListElement(string);
                if (nVPair == null) continue;
                break;
            }
        }
        if (nVPair == null) {
            throw new NetException(122, "\"" + string + "\"");
        }
        return nVPair.valueToString();
    }

    private void loadFiles() throws NetException {
        File file = new File(this.tnsDir, TNSFILE);
        String string = file.getAbsolutePath();
        this.loadFiles(string, 0);
    }

    private void loadFiles(String string, int n2) throws NetException {
        if (n2 >= 5) {
            return;
        }
        File file = new File(string);
        if (!file.isFile() || !file.canRead()) {
            return;
        }
        try {
            NLParamParser nLParamParser = new NLParamParser(string, 1);
            this.tnsFiles.add(new TNSFile(string, file.lastModified(), nLParamParser));
            NVPair nVPair = nLParamParser.getNLPListElement("ifile");
            if (nVPair != null) {
                ArrayList<String> arrayList = this.getIFile(string);
                for (String string2 : arrayList) {
                    this.loadFiles(string2, n2 + 1);
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (NLException nLException) {
            // empty catch block
        }
    }

    private ArrayList<String> getIFile(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        Matcher matcher = regexp.matcher("");
        ArrayList<String> arrayList = new ArrayList<String>(2);
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            matcher.reset(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(2);
            File file = new File(string3 = string3.trim());
            if (!file.isAbsolute()) {
                file = new File(this.tnsDir, string3);
                string3 = file.getAbsolutePath();
            }
            arrayList.add(string3);
        }
        return arrayList;
    }

    private void checkAndReload() throws NetException {
        long l2 = System.currentTimeMillis();
        if (l2 > this.nextPollTime) {
            this.nextPollTime = 0L;
            this.reloadFiles();
        }
    }

    private void reloadFiles() throws NetException {
        if (this.tnsFiles.isEmpty()) {
            this.loadFiles();
        } else {
            for (TNSFile tNSFile : this.tnsFiles) {
                long l2 = tNSFile.getLastModifiedTime();
                String string = tNSFile.getFileName();
                File file = new File(string);
                boolean bl = !file.isFile() || !file.canRead() || file.lastModified() != l2;
                if (!bl) continue;
                this.resetAttr();
                this.loadFiles();
                break;
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

