/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.core.db.ODatabaseSessionMetadata;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class OStorageRemoteSession
implements ODatabaseSessionMetadata {
    public boolean commandExecuting = false;
    public int serverURLIndex = -1;
    public Set<OChannelBinary> connections = Collections.newSetFromMap(new WeakHashMap());
    public String connectionUserName = null;
    public String connectionUserPassword = null;
    public Map<String, OStorageRemoteNodeSession> sessions = new HashMap<String, OStorageRemoteNodeSession>();
    public final Integer uniqueClientSessionId;

    public OStorageRemoteSession(int sessionId) {
        this.uniqueClientSessionId = sessionId;
    }

    public boolean has(OChannelBinary connection) {
        return this.connections.contains(connection);
    }

    public OStorageRemoteNodeSession get(String serverURL) {
        return this.sessions.get(serverURL);
    }

    public OStorageRemoteNodeSession getOrCreate(String serverURL) {
        OStorageRemoteNodeSession session = this.sessions.get(serverURL);
        if (session == null) {
            session = new OStorageRemoteNodeSession(serverURL, this.uniqueClientSessionId);
            this.sessions.put(serverURL, session);
        }
        return session;
    }

    public void add(OChannelBinary connection) {
        this.connections.add(connection);
    }

    public void clear() {
        this.connections.clear();
    }

    public void close() {
        this.commandExecuting = false;
        this.serverURLIndex = -1;
        this.connections = new HashSet<OChannelBinary>();
        this.sessions = new HashMap<String, OStorageRemoteNodeSession>();
    }

    public Integer getSessionId() {
        if (this.sessions.isEmpty()) {
            return -1;
        }
        OStorageRemoteNodeSession curSession = this.sessions.values().iterator().next();
        return curSession.getSessionId();
    }

    public String getServerUrl() {
        if (this.sessions.isEmpty()) {
            return null;
        }
        OStorageRemoteNodeSession curSession = this.sessions.values().iterator().next();
        return curSession.getServerURL();
    }

    public void remove(String serverURL) {
        this.sessions.remove(serverURL);
    }

    public Collection<OStorageRemoteNodeSession> getAll() {
        return this.sessions.values();
    }
}

