/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
abstract class AbstractBindingCache<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @GuardedBy(value="this")
    private final Set<T> cachedBindings = new HashSet<T>();
    @GuardedBy(value="this")
    private final Set<T> extantBindings = new HashSet<T>();

    AbstractBindingCache() {
    }

    @Nonnull
    abstract T getNewBinding();

    @Nonnull
    final synchronized T getBinding() {
        T binding;
        Iterator<T> iterator = this.cachedBindings.iterator();
        if (iterator.hasNext()) {
            binding = iterator.next();
            iterator.remove();
        } else {
            this.logger.trace("Creating a new binding");
            binding = this.getNewBinding();
        }
        this.extantBindings.add(binding);
        return binding;
    }

    final synchronized void releaseBinding(@Nonnull T binding) {
        if (!this.extantBindings.remove(binding)) {
            throw new IllegalArgumentException("Got a binding that wasn't an extant binding for this cache");
        }
        if (!this.cachedBindings.add(binding)) {
            throw new IllegalStateException("This should be impossible: binding was in extant and already in the cache");
        }
    }

    @VisibleForTesting
    final synchronized Set<T> getCachedBindings() {
        return Collections.unmodifiableSet(new HashSet<T>(this.cachedBindings));
    }

    @VisibleForTesting
    final synchronized Set<T> getExtant() {
        return Collections.unmodifiableSet(new HashSet<T>(this.extantBindings));
    }
}

