/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.PartnerApiError;
import com.palominolabs.crm.sf.soap.PartnerApiErrorImpl;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class AbstractCallResult {
    @Nullable
    private final Id id;
    private final boolean success;
    @Nonnull
    private final List<PartnerApiError> errors;

    AbstractCallResult(@Nullable String idStr, boolean success, @Nonnull List<ErrorType> stubErrors) {
        this.id = idStr == null ? null : new Id(idStr);
        this.success = success;
        ArrayList<PartnerApiErrorImpl> mutableErrorList = new ArrayList<PartnerApiErrorImpl>();
        for (ErrorType stubError : stubErrors) {
            mutableErrorList.add(new PartnerApiErrorImpl(stubError));
        }
        this.errors = Collections.unmodifiableList(mutableErrorList);
    }

    @Nullable
    public Id getId() {
        return this.id;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nonnull
    public List<PartnerApiError> getErrors() {
        return this.errors;
    }

    public String toString() {
        return this.getClass().getName() + "{" + "id=" + this.id + ", success=" + this.success + ", errors=" + this.errors + '}';
    }
}

