/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.soap.ApiException;
import com.palominolabs.crm.sf.soap.CallSemaphore;
import com.palominolabs.crm.sf.soap.ConfiguredBinding;
import com.palominolabs.crm.sf.soap.ConnectionBundleImpl;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
abstract class AbstractSalesforceConnection {
    private final CallSemaphore semaphore;
    final ConnectionBundleImpl connBundle;

    AbstractSalesforceConnection(@Nonnull CallSemaphore semaphore, @Nonnull ConnectionBundleImpl connBundle) {
        this.semaphore = semaphore;
        this.connBundle = connBundle;
    }

    final void acquireSemaphore() throws ApiException {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.getApiExceptionWithCause("Interrupted while getting a permit", e);
        }
    }

    @Nonnull
    ApiException getApiExceptionWithCause(@Nonnull String message, @Nonnull Throwable cause) {
        return ApiException.getNewWithCause(message, this.getUsername(), cause);
    }

    final void releaseSemaphore() {
        this.semaphore.release();
    }

    @Nonnull
    final String getUsername() {
        return this.connBundle.getUsername();
    }

    abstract class ApiOperation<Tin, Tout, B> {
        ApiOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Tout execute(Tin param) throws ApiException {
            ConfiguredBinding<B> configuredBinding = this.getBinding();
            try {
                Tout Tout = this.executeImpl(configuredBinding, param);
                return Tout;
            }
            finally {
                this.releaseBinding(configuredBinding.getBinding());
            }
        }

        @Nonnull
        abstract Tout executeImpl(@Nonnull ConfiguredBinding<B> var1, @Nonnull Tin var2) throws ApiException;

        @Nonnull
        abstract ConfiguredBinding<B> getBinding() throws ApiException;

        abstract void releaseBinding(@Nonnull B var1);
    }
}

