/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.palominolabs.crm.sf.soap.AbstractSalesforceConnection;
import com.palominolabs.crm.sf.soap.ApexConnection;
import com.palominolabs.crm.sf.soap.ApiException;
import com.palominolabs.crm.sf.soap.CallSemaphore;
import com.palominolabs.crm.sf.soap.ConfiguredBinding;
import com.palominolabs.crm.sf.soap.ConnectionBundleImpl;
import com.palominolabs.crm.sf.soap.ExecuteAnonResult;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.ApexPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.ExecuteAnonymousResult;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.developer.WSBindingProvider;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;

@ThreadSafe
final class ApexConnectionImpl
extends AbstractSalesforceConnection
implements ApexConnection {
    private final MetricRegistry metricRegistry;

    ApexConnectionImpl(@Nonnull CallSemaphore semaphore, @Nonnull ConnectionBundleImpl bundle, MetricRegistry metricRegistry) {
        super(semaphore, bundle);
        this.metricRegistry = metricRegistry;
    }

    @Override
    public synchronized ExecuteAnonResult executeAnonymous(String code) throws ApiException {
        return (ExecuteAnonResult)new ExecuteAnonymousOp().execute(code);
    }

    private class ExecuteAnonymousOp
    extends ApexOperation<String, ExecuteAnonResult> {
        private ExecuteAnonymousOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        ExecuteAnonResult executeOp(@Nonnull ApexPortType binding, @Nonnull String param) throws ApiException {
            ExecuteAnonymousResult result = binding.executeAnonymous(param);
            HeaderList headers = (HeaderList)((WSBindingProvider)binding).getResponseContext().get("com.sun.xml.ws.api.message.HeaderList");
            String debugLog = null;
            for (Header header : headers) {
                if (!"DebuggingInfo".equals(header.getLocalPart())) continue;
                try {
                    XMLStreamReader reader = header.readHeader();
                    try {
                        if (!reader.hasNext()) {
                            throw ApiException.getNew("Unexpected debug log format", ApexConnectionImpl.this.getUsername());
                        }
                        int eventType = reader.next();
                        if (1 != eventType || !"DebuggingInfo".equals(reader.getLocalName())) {
                            throw ApiException.getNew("Unexpected debug log format", ApexConnectionImpl.this.getUsername());
                        }
                        if (!reader.hasNext()) {
                            throw ApiException.getNew("Unexpected debug log format", ApexConnectionImpl.this.getUsername());
                        }
                        eventType = reader.next();
                        if (1 != eventType || !"debugLog".equals(reader.getLocalName())) {
                            throw ApiException.getNew("Unexpected debug log format", ApexConnectionImpl.this.getUsername());
                        }
                        if (!reader.hasNext()) {
                            throw ApiException.getNew("Unexpected debug log format", ApexConnectionImpl.this.getUsername());
                        }
                        eventType = reader.next();
                        if (eventType == 2) {
                            debugLog = "";
                            continue;
                        }
                        if (4 != eventType || !"debugLog".equals(reader.getLocalName())) {
                            throw ApiException.getNew("Unexpected debug log format", ApexConnectionImpl.this.getUsername());
                        }
                        StringBuilder sb = new StringBuilder();
                        do {
                            sb.append(reader.getText());
                        } while (reader.hasNext() && reader.next() == 4);
                        debugLog = sb.toString();
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (XMLStreamException e) {
                    throw this.getNewExceptionWithCause("Error extracting header", e);
                }
            }
            if (debugLog == null) {
                throw ApiException.getNew("No debug log header", ApexConnectionImpl.this.getUsername());
            }
            return new ExecuteAnonResult(result, debugLog);
        }
    }

    private abstract class ApexOperation<Tin, Tout>
    extends AbstractSalesforceConnection.ApiOperation<Tin, Tout, ApexPortType> {
        private final Timer timer;

        private ApexOperation() {
            this.timer = ApexConnectionImpl.this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"request"}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        Tout executeImpl(@Nonnull ConfiguredBinding<ApexPortType> apexPortTypeConfiguredBinding, @Nonnull Tin param) throws ApiException {
            Timer.Context context = this.timer.time();
            try {
                Tout Tout;
                ApexConnectionImpl.this.acquireSemaphore();
                try {
                    Tout = this.executeOp(apexPortTypeConfiguredBinding.getBinding(), param);
                }
                catch (Throwable throwable) {
                    try {
                        ApexConnectionImpl.this.releaseSemaphore();
                        throw throwable;
                    }
                    catch (WebServiceException e) {
                        throw this.getNewExceptionWithCause("Call failed", e);
                    }
                }
                ApexConnectionImpl.this.releaseSemaphore();
                return Tout;
            }
            finally {
                context.stop();
            }
        }

        @Nonnull
        abstract Tout executeOp(@Nonnull ApexPortType var1, @Nonnull Tin var2) throws ApiException;

        @Override
        @Nonnull
        ConfiguredBinding<ApexPortType> getBinding() throws ApiException {
            return ApexConnectionImpl.this.connBundle.getApexBinding();
        }

        @Override
        void releaseBinding(@Nonnull ApexPortType binding) {
            ApexConnectionImpl.this.connBundle.acceptReleasedApexBinding(binding);
        }

        @Nonnull
        ApiException getNewExceptionWithCause(@Nonnull String message, @Nonnull Throwable cause) {
            return ApiException.getNewWithCause(message, ApexConnectionImpl.this.getUsername(), cause);
        }
    }
}

