/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.soap.ApiFault;
import com.palominolabs.crm.sf.soap.ApiFaultImpl;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ApiQueryFault;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ExceptionCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final ApiFault apiFault;
    @Nonnull
    private final String username;

    private ApiException(@Nonnull String message, @Nonnull String username) {
        super(message);
        this.username = username;
        this.apiFault = null;
    }

    private ApiException(@Nonnull String message, @Nonnull String username, @Nonnull Throwable cause) {
        super(message, cause);
        this.username = username;
        this.apiFault = null;
    }

    private ApiException(@Nonnull String message, @Nonnull Throwable cause, @Nonnull ApiFault fault) {
        super(message, cause);
        this.username = fault.getUsername();
        this.apiFault = fault;
    }

    static ApiException getNew(@Nonnull String message, @Nonnull String username) {
        return new ApiException(message, username);
    }

    static ApiException getNewWithCause(@Nonnull String message, @Nonnull String username, @Nonnull Throwable cause) {
        return new ApiException(message, username, cause);
    }

    static ApiException getNewWithCauseAndStubApiFault(@Nonnull String message, @Nonnull String username, @Nonnull Throwable cause, @Nonnull com.palominolabs.crm.sf.soap.jaxwsstub.partner.ApiFault stubFault) {
        return new ApiException(message, cause, new ApiFaultImpl(stubFault.getExceptionCode(), stubFault.getExceptionMessage(), username));
    }

    static ApiException getNewWithCauseAndStubApiQueryFault(@Nonnull String message, @Nonnull String username, @Nonnull Throwable cause, @Nonnull ApiQueryFault stubFault) {
        return new ApiException(message, cause, new ApiFaultImpl(stubFault.getExceptionCode(), stubFault.getExceptionMessage(), username, stubFault.getRow(), stubFault.getColumn()));
    }

    static ApiException getNewWithApiExceptionCause(@Nonnull String message, @Nonnull ApiException cause) {
        ApiFault fault = cause.getApiFault();
        if (fault == null) {
            return new ApiException(message, cause.getUsername(), cause);
        }
        return new ApiException(message, cause, fault);
    }

    @Nullable
    public ApiFault getApiFault() {
        return this.apiFault;
    }

    @Nullable
    public ExceptionCode getApiFaultCode() {
        if (this.apiFault == null) {
            return null;
        }
        return this.apiFault.getFaultCode();
    }

    @Nullable
    public String getApiFaultCodeString() {
        if (this.getApiFaultCode() == null) {
            return null;
        }
        return this.getApiFaultCode().value();
    }

    @Nullable
    public String getApiFaultMessage() {
        if (this.apiFault == null) {
            return null;
        }
        return this.apiFault.getFaultMessage();
    }

    @Nullable
    public Integer getApiFaultRow() {
        if (this.apiFault == null) {
            return null;
        }
        return this.apiFault.getRow();
    }

    @Nullable
    public Integer getApiFaultColumn() {
        if (this.apiFault == null) {
            return null;
        }
        return this.apiFault.getColumn();
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        if (this.apiFault == null) {
            buf.append(" {username='").append(this.username).append("'}");
        } else {
            buf.append(" ").append(this.apiFault.toString());
        }
        return buf.toString();
    }
}

