/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.palominolabs.crm.sf.core.Id;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BindingConfig {
    @Nonnull
    private final Id orgId;
    @Nonnull
    private final String partnerServerUrl;
    @Nonnull
    private final String metadataServerUrl;
    @Nonnull
    private final String apexServerUrl;
    @Nonnull
    private final String sessionId;
    @Nonnull
    private final String username;

    BindingConfig(@Nonnull Id orgId, @Nonnull String sessionId, @Nonnull String partnerServerUrl, @Nonnull String metadataServerUrl, @Nonnull String username) {
        this.sessionId = sessionId;
        this.orgId = orgId;
        this.partnerServerUrl = partnerServerUrl;
        this.metadataServerUrl = metadataServerUrl;
        try {
            URL url = new URL(metadataServerUrl);
            this.apexServerUrl = "https://" + url.getHost() + "/services/Soap/s/" + "28.0";
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid metadata server url: " + metadataServerUrl, e);
        }
        this.username = username;
    }

    @Nonnull
    public Id getOrgId() {
        return this.orgId;
    }

    @Nonnull
    public String getSessionId() {
        return this.sessionId;
    }

    @Nonnull
    public String getMetadataServerUrl() {
        return this.metadataServerUrl;
    }

    @Nonnull
    public String getPartnerServerUrl() {
        return this.partnerServerUrl;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getApexServerUrl() {
        return this.apexServerUrl;
    }
}

