/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.ApiException;
import com.palominolabs.crm.sf.soap.BindingConfig;
import com.palominolabs.crm.sf.soap.CallSemaphore;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.ApexPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.DebuggingHeader;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.LogCategory;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.LogCategoryLevel;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.LogInfo;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.LogType;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.CallOptions;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.MetadataPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.ApiFault;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.InvalidIdFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Login;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.LoginFault_Exception;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.LoginResponse;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.LoginResultType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.SessionHeader;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Soap;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.UnexpectedErrorFault_Exception;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@ThreadSafe
final class BindingConfigurer {
    private static final String SANDBOX_INITIAL_ENDPOINT = "https://test.salesforce.com/services/Soap/u/28.0";
    private static final String NORMAL_INITIAL_ENDPOINT = "https://login.salesforce.com/services/Soap/u/28.0";
    private static final XLogger logger = XLoggerFactory.getXLogger(BindingConfigurer.class);
    private final JAXBRIContext partnerJaxbContext;
    private final JAXBRIContext metadataJaxbContext;
    private final JAXBRIContext apexJaxbContext;
    @Nonnull
    private final String partnerKey;
    private final Timer loginTimer;

    BindingConfigurer(@Nonnull String partnerKey, MetricRegistry metricRegistry) {
        this.loginTimer = metricRegistry.timer(MetricRegistry.name(BindingConfigurer.class, (String[])new String[]{"login"}));
        this.partnerKey = partnerKey;
        try {
            this.partnerJaxbContext = (JAXBRIContext)JAXBContext.newInstance((String)Soap.class.getPackage().getName());
            this.metadataJaxbContext = (JAXBRIContext)JAXBContext.newInstance((String)MetadataPortType.class.getPackage().getName());
            this.apexJaxbContext = (JAXBRIContext)JAXBContext.newInstance((String)ApexPortType.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not load JAXB context", e);
        }
    }

    void configureMetadataBinding(@Nonnull MetadataPortType metadataBinding, @Nonnull BindingConfig bindingConfig) {
        WSBindingProvider metadataWsBindingProvider = (WSBindingProvider)metadataBinding;
        this.configureRequestContextConnectionParams(metadataWsBindingProvider);
        com.palominolabs.crm.sf.soap.jaxwsstub.metadata.SessionHeader sessionHeader = new com.palominolabs.crm.sf.soap.jaxwsstub.metadata.SessionHeader();
        sessionHeader.setSessionId(bindingConfig.getSessionId());
        ArrayList<Header> headers = new ArrayList<Header>();
        CallOptions metadataCallOpts = new CallOptions();
        metadataCallOpts.setClient(this.partnerKey);
        headers.add(Headers.create((JAXBRIContext)this.metadataJaxbContext, (Object)sessionHeader));
        headers.add(Headers.create((JAXBRIContext)this.metadataJaxbContext, (Object)metadataCallOpts));
        metadataWsBindingProvider.setOutboundHeaders(headers);
        metadataWsBindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", bindingConfig.getMetadataServerUrl());
        logger.exit((Object)("User " + bindingConfig.getUsername() + ", session id " + bindingConfig.getSessionId() + " on metadata server" + bindingConfig.getMetadataServerUrl()));
    }

    @Nonnull
    BindingConfig loginAndGetBindingConfigData(@Nonnull String username, @Nonnull String password, @Nonnull Soap binding, @Nonnull CallSemaphore callSemaphore, boolean sandboxOrg) throws ApiException {
        LoginResponse response;
        Login loginParam = new Login();
        loginParam.setPassword(password);
        loginParam.setUsername(username);
        WSBindingProvider wsBindingProvider = (WSBindingProvider)binding;
        if (sandboxOrg) {
            wsBindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", SANDBOX_INITIAL_ENDPOINT);
        } else {
            wsBindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", NORMAL_INITIAL_ENDPOINT);
        }
        logger.trace("Using initial endpoint: " + wsBindingProvider.getRequestContext().get("javax.xml.ws.service.endpoint.address"));
        com.palominolabs.crm.sf.soap.jaxwsstub.partner.CallOptions callOpts = new com.palominolabs.crm.sf.soap.jaxwsstub.partner.CallOptions();
        callOpts.setClient(this.partnerKey);
        wsBindingProvider.setOutboundHeaders(new Header[]{Headers.create((JAXBRIContext)this.partnerJaxbContext, (Object)callOpts)});
        this.configureRequestContextConnectionParams(wsBindingProvider);
        try {
            callSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ApiException.getNewWithCause("Interrupted while getting a call token to make the login call", username, e);
        }
        Timer.Context context = this.loginTimer.time();
        try {
            response = binding.login(loginParam);
        }
        catch (InvalidIdFault_Exception e) {
            throw ApiException.getNewWithCauseAndStubApiFault("Invalid Id", username, e, (ApiFault)e.getFaultInfo());
        }
        catch (LoginFault_Exception e) {
            throw ApiException.getNewWithCauseAndStubApiFault("Bad credentials for user '" + username + "'", username, e, (ApiFault)e.getFaultInfo());
        }
        catch (UnexpectedErrorFault_Exception e) {
            throw ApiException.getNewWithCauseAndStubApiFault("Unexpected error", username, e, (ApiFault)e.getFaultInfo());
        }
        catch (WebServiceException e) {
            throw ApiException.getNewWithCause("Web Service exception", username, e);
        }
        finally {
            callSemaphore.release();
            context.stop();
        }
        LoginResultType loginResult = response.getResult();
        logger.debug("User " + username + " using partner endpoint " + loginResult.getServerUrl());
        Id orgId = new Id(loginResult.getUserInfo().getOrganizationId());
        String sessionId = loginResult.getSessionId();
        return new BindingConfig(orgId, sessionId, loginResult.getServerUrl(), loginResult.getMetadataServerUrl(), username);
    }

    void configurePartnerBinding(Soap binding, BindingConfig bindingConfig) {
        WSBindingProvider wsBindingProvider = (WSBindingProvider)binding;
        this.configureRequestContextConnectionParams(wsBindingProvider);
        wsBindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", bindingConfig.getPartnerServerUrl());
        SessionHeader sessionHeader = new SessionHeader();
        sessionHeader.setSessionId(bindingConfig.getSessionId());
        ArrayList<Header> headers = new ArrayList<Header>();
        com.palominolabs.crm.sf.soap.jaxwsstub.partner.CallOptions callOptions = new com.palominolabs.crm.sf.soap.jaxwsstub.partner.CallOptions();
        callOptions.setClient(this.partnerKey);
        headers.add(Headers.create((JAXBRIContext)this.partnerJaxbContext, (Object)sessionHeader));
        headers.add(Headers.create((JAXBRIContext)this.partnerJaxbContext, (Object)callOptions));
        wsBindingProvider.setOutboundHeaders(headers);
    }

    void configureApexBinding(ApexPortType binding, BindingConfig bindingConfig) {
        WSBindingProvider apexWsBindingProvider = (WSBindingProvider)binding;
        this.configureRequestContextConnectionParams(apexWsBindingProvider);
        com.palominolabs.crm.sf.soap.jaxwsstub.apex.SessionHeader sessionHeader = new com.palominolabs.crm.sf.soap.jaxwsstub.apex.SessionHeader();
        sessionHeader.setSessionId(bindingConfig.getSessionId());
        ArrayList<Header> headers = new ArrayList<Header>();
        com.palominolabs.crm.sf.soap.jaxwsstub.apex.CallOptions apexCallOpts = new com.palominolabs.crm.sf.soap.jaxwsstub.apex.CallOptions();
        apexCallOpts.setClient(this.partnerKey);
        DebuggingHeader apexDebug = new DebuggingHeader();
        apexDebug.setDebugLevel(LogType.PROFILING);
        for (LogCategory category : LogCategory.values()) {
            LogInfo logInfo = new LogInfo();
            logInfo.setCategory(category);
            logInfo.setLevel(LogCategoryLevel.DEBUG);
            apexDebug.getCategories().add(logInfo);
        }
        headers.add(Headers.create((JAXBRIContext)this.apexJaxbContext, (Object)sessionHeader));
        headers.add(Headers.create((JAXBRIContext)this.apexJaxbContext, (Object)apexCallOpts));
        headers.add(Headers.create((JAXBRIContext)this.apexJaxbContext, (Object)apexDebug));
        apexWsBindingProvider.setOutboundHeaders(headers);
        apexWsBindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", bindingConfig.getApexServerUrl());
        logger.exit((Object)("User " + bindingConfig.getUsername() + ", session id " + bindingConfig.getSessionId() + " on apex server" + bindingConfig.getApexServerUrl()));
    }

    private void configureRequestContextConnectionParams(@Nonnull WSBindingProvider wsBindingProvider) {
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        wsBindingProvider.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
        int connectTimeout = 10000;
        int readTimeout = 600000;
        wsBindingProvider.getRequestContext().put("com.sun.xml.ws.connect.timeout", connectTimeout);
        wsBindingProvider.getRequestContext().put("com.sun.xml.ws.request.timeout", readTimeout);
    }
}

