/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.codahale.metrics.MetricRegistry;
import com.palominolabs.crm.sf.soap.ApexBindingCache;
import com.palominolabs.crm.sf.soap.ApiException;
import com.palominolabs.crm.sf.soap.BindingConfig;
import com.palominolabs.crm.sf.soap.BindingConfigurer;
import com.palominolabs.crm.sf.soap.CallSemaphore;
import com.palominolabs.crm.sf.soap.MetadataBindingCache;
import com.palominolabs.crm.sf.soap.PartnerBindingCache;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.ApexPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.MetadataPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Soap;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class BindingRepository {
    private final PartnerBindingCache partnerBindingCache = new PartnerBindingCache();
    private final MetadataBindingCache metadataBindingCache = new MetadataBindingCache();
    private final ApexBindingCache apexBindingCache = new ApexBindingCache();
    private final BindingConfigurer bindingConfigurer;

    BindingRepository(@Nonnull String partnerKey, MetricRegistry metricsRegistry) {
        this.bindingConfigurer = new BindingConfigurer(partnerKey, metricsRegistry);
    }

    @Nonnull
    Soap getPartnerBinding(@Nonnull BindingConfig bindingConfig) {
        Soap binding = (Soap)this.partnerBindingCache.getBinding();
        this.bindingConfigurer.configurePartnerBinding(binding, bindingConfig);
        return binding;
    }

    void releasePartnerBinding(@Nonnull Soap binding) {
        this.partnerBindingCache.releaseBinding(binding);
    }

    @Nonnull
    MetadataPortType getMetadataBinding(@Nonnull BindingConfig bindingConfig) {
        MetadataPortType binding = (MetadataPortType)this.metadataBindingCache.getBinding();
        this.bindingConfigurer.configureMetadataBinding(binding, bindingConfig);
        return binding;
    }

    void releaseMetadataBinding(@Nonnull MetadataPortType binding) {
        this.metadataBindingCache.releaseBinding(binding);
    }

    @Nonnull
    ApexPortType getApexBinding(@Nonnull BindingConfig bindingConfig) {
        ApexPortType binding = (ApexPortType)this.apexBindingCache.getBinding();
        this.bindingConfigurer.configureApexBinding(binding, bindingConfig);
        return binding;
    }

    void releaseApexBinding(@Nonnull ApexPortType binding) {
        this.apexBindingCache.releaseBinding(binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    BindingConfig getBindingConfigData(@Nonnull String username, @Nonnull String password, @Nonnull CallSemaphore callSemaphore, boolean sandboxOrg) throws ApiException {
        Soap binding = (Soap)this.partnerBindingCache.getBinding();
        try {
            BindingConfig bindingConfig = this.bindingConfigurer.loginAndGetBindingConfigData(username, password, binding, callSemaphore, sandboxOrg);
            return bindingConfig;
        }
        finally {
            this.releasePartnerBinding(binding);
        }
    }
}

