/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import java.util.concurrent.Semaphore;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class CallSemaphore {
    private static final Logger logger = LoggerFactory.getLogger(CallSemaphore.class);
    private final ResizeableSemaphore semaphore = new ResizeableSemaphore();
    @GuardedBy(value="this")
    private int maxPermits = 0;

    CallSemaphore() {
    }

    synchronized void setMaxPermits(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException("Semaphore size must be at least 1, was " + newMax);
        }
        int delta = newMax - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            logger.debug("Increasing size by " + delta + " to " + newMax);
            this.semaphore.release(delta);
        } else {
            logger.debug("Decreasing size by " + (delta *= -1) + " to " + newMax);
            this.semaphore.reducePermits(delta);
        }
        this.maxPermits = newMax;
    }

    void release() {
        this.semaphore.release();
    }

    void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 1L;

        ResizeableSemaphore() {
            super(0);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

