/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.codahale.metrics.MetricRegistry;
import com.palominolabs.crm.sf.core.Id;
import com.palominolabs.crm.sf.soap.ApexConnection;
import com.palominolabs.crm.sf.soap.ApexConnectionImpl;
import com.palominolabs.crm.sf.soap.ApiException;
import com.palominolabs.crm.sf.soap.BindingConfig;
import com.palominolabs.crm.sf.soap.BindingRepository;
import com.palominolabs.crm.sf.soap.CallSemaphore;
import com.palominolabs.crm.sf.soap.ConfiguredBinding;
import com.palominolabs.crm.sf.soap.ConnectionBundle;
import com.palominolabs.crm.sf.soap.MetadataConnection;
import com.palominolabs.crm.sf.soap.MetadataConnectionImpl;
import com.palominolabs.crm.sf.soap.PartnerConnection;
import com.palominolabs.crm.sf.soap.PartnerConnectionImpl;
import com.palominolabs.crm.sf.soap.jaxwsstub.apex.ApexPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.metadata.MetadataPortType;
import com.palominolabs.crm.sf.soap.jaxwsstub.partner.Soap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@ThreadSafe
final class ConnectionBundleImpl
implements ConnectionBundle {
    private static final XLogger logger = XLoggerFactory.getXLogger(ConnectionBundleImpl.class);
    @Nonnull
    private final CallSemaphore callSemaphore;
    @Nonnull
    private final BindingRepository bindingRepository;
    private final boolean sandboxOrg;
    @Nullable
    @GuardedBy(value="this")
    private Id orgId = null;
    @Nonnull
    @GuardedBy(value="this")
    private String username;
    @Nonnull
    @GuardedBy(value="this")
    private String password;
    @Nullable
    @GuardedBy(value="this")
    private BindingConfig bindingConfig = null;
    private final MetricRegistry metricRegistry;

    private ConnectionBundleImpl(@Nonnull String username, @Nonnull String password, int maxConcurrentApiCalls, @Nonnull BindingRepository bindingRepository, boolean sandboxOrg, MetricRegistry metricRegistry) {
        this.sandboxOrg = sandboxOrg;
        this.bindingRepository = bindingRepository;
        this.metricRegistry = metricRegistry;
        this.callSemaphore = new CallSemaphore();
        this.updateCredentials(username, password, maxConcurrentApiCalls);
    }

    static ConnectionBundleImpl getNew(@Nonnull BindingRepository bindingRepository, @Nonnull String username, @Nonnull String password, int maxConcurrentApiCalls, MetricRegistry metricRegistry) {
        return new ConnectionBundleImpl(username, password, maxConcurrentApiCalls, bindingRepository, false, metricRegistry);
    }

    static ConnectionBundleImpl getNewForSandbox(@Nonnull BindingRepository bindingRepository, @Nonnull String username, @Nonnull String password, int maxConcurrentApiCalls, MetricRegistry metricRegistry) {
        return new ConnectionBundleImpl(username, password, maxConcurrentApiCalls, bindingRepository, true, metricRegistry);
    }

    synchronized void updateCredentials(@Nonnull String newUsername, @Nonnull String newPassword, int maxConcurrentApiCalls) {
        if (newUsername == null) {
            throw new NullPointerException("Username can't be null");
        }
        if (newPassword == null) {
            throw new NullPointerException("Password can't be null");
        }
        logger.trace("Updating maxApiCalls to " + maxConcurrentApiCalls);
        this.callSemaphore.setMaxPermits(maxConcurrentApiCalls);
        if (newUsername.equals(this.username) && newPassword.equals(this.password)) {
            logger.trace("Got new credentials that were equal to the old credentials");
        } else {
            logger.trace("Updating username to <" + newUsername + "> from <" + this.username + ">");
            this.bindingConfig = null;
            this.username = newUsername;
            this.password = newPassword;
        }
    }

    @Override
    @Nonnull
    public synchronized PartnerConnection getPartnerConnection() {
        return PartnerConnectionImpl.getNew(this.callSemaphore, this, this.metricRegistry);
    }

    @Nonnull
    synchronized String getUsername() {
        return this.username;
    }

    @Override
    @Nonnull
    public synchronized MetadataConnection getMetadataConnection() {
        return new MetadataConnectionImpl(this.callSemaphore, this, this.metricRegistry);
    }

    @Override
    @Nonnull
    public synchronized ApexConnection getApexConnection() {
        return new ApexConnectionImpl(this.callSemaphore, this, this.metricRegistry);
    }

    @Nonnull
    synchronized ConfiguredBinding<MetadataPortType> getMetadataBinding() throws ApiException {
        BindingConfig data = this.getBindingConfig();
        return new ConfiguredBinding<MetadataPortType>(this.bindingRepository.getMetadataBinding(data), data);
    }

    synchronized void acceptReleasedMetadataBinding(@Nonnull MetadataPortType binding) {
        this.bindingRepository.releaseMetadataBinding(binding);
    }

    @Nonnull
    synchronized ConfiguredBinding<ApexPortType> getApexBinding() throws ApiException {
        BindingConfig data = this.getBindingConfig();
        return new ConfiguredBinding<ApexPortType>(this.bindingRepository.getApexBinding(data), data);
    }

    synchronized void acceptReleasedApexBinding(@Nonnull ApexPortType binding) {
        this.bindingRepository.releaseApexBinding(binding);
    }

    @Nonnull
    synchronized ConfiguredBinding<Soap> getPartnerBinding() throws ApiException {
        BindingConfig data = this.getBindingConfig();
        return new ConfiguredBinding<Soap>(this.bindingRepository.getPartnerBinding(data), data);
    }

    synchronized void acceptReleasedPartnerBinding(@Nonnull Soap binding) {
        this.bindingRepository.releasePartnerBinding(binding);
    }

    synchronized void reportBadSessionId() throws ApiException {
        this.bindingConfig = null;
        logger.info("Attempting to get new session id");
        this.getBindingConfig();
    }

    @Override
    @Nonnull
    public synchronized BindingConfig getBindingConfig() throws ApiException {
        if (this.bindingConfig == null) {
            BindingConfig newBindingConfig = this.bindingRepository.getBindingConfigData(this.username, this.password, this.callSemaphore, this.sandboxOrg);
            String sessionId = newBindingConfig.getSessionId();
            if (this.orgId == null) {
                this.orgId = newBindingConfig.getOrgId();
                logger.trace("Setting the bundle's org id to <" + this.orgId + "> from its first connection");
            } else if (!this.orgId.equals((Object)newBindingConfig.getOrgId())) {
                throw new IllegalStateException("Somehow got a binding with a different organization Id: expected <" + this.orgId + ">, got <" + newBindingConfig.getOrgId() + ">. Did you update the credentials to those of a different org?");
            }
            logger.trace("User " + this.username + ", session id " + sessionId + " on metadata server" + newBindingConfig.getMetadataServerUrl());
            this.bindingConfig = newBindingConfig;
        }
        return this.bindingConfig;
    }
}

