/*
 * Decompiled with CFR 0.152.
 */
package com.palominolabs.crm.sf.soap;

import com.codahale.metrics.MetricRegistry;
import com.palominolabs.crm.sf.soap.BindingRepository;
import com.palominolabs.crm.sf.soap.ConnectionBundle;
import com.palominolabs.crm.sf.soap.ConnectionBundleImpl;
import com.palominolabs.crm.sf.soap.ConnectionPool;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ConnectionPoolImpl<T>
implements ConnectionPool<T> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPoolImpl.class);
    private static final BundleFactory NORMAL_BUNDLE_FACTORY = new NormalBundleFactory();
    private static final BundleFactory SANDBOX_BUNDLE_FACTORY = new SandboxBundleFactory();
    private final Map<T, ConnectionBundleImpl> orgIdToBundleMap = new HashMap<T, ConnectionBundleImpl>();
    private final Map<T, ConnectionBundleImpl> orgIdToSandboxBundleMap = new HashMap<T, ConnectionBundleImpl>();
    private final BindingRepository bindingRepository;
    private final MetricRegistry metricRegistry;

    public ConnectionPoolImpl(@Nonnull String partnerKey, MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.bindingRepository = new BindingRepository(partnerKey, metricRegistry);
    }

    @Override
    @Nonnull
    public synchronized ConnectionBundle getConnectionBundle(@Nonnull T orgIdentifier) {
        return this.getConnectionBundleImpl(this.orgIdToBundleMap, orgIdentifier);
    }

    @Override
    @Nonnull
    public synchronized ConnectionBundle getSandboxConnectionBundle(@Nonnull T orgIdentifier) {
        return this.getConnectionBundleImpl(this.orgIdToSandboxBundleMap, orgIdentifier);
    }

    private ConnectionBundle getConnectionBundleImpl(Map<T, ConnectionBundleImpl> bundles, T orgId) {
        ConnectionBundle cp = bundles.get(orgId);
        if (cp == null) {
            throw new IllegalStateException("The ConnectionBundle for org id <" + orgId + "> has not been configured yet!");
        }
        return cp;
    }

    @Override
    public synchronized void configureOrg(@Nonnull T orgId, @Nonnull String username, @Nonnull String password, int maxConcurrentApiCalls) {
        this.configureOrgImpl(orgId, username, password, maxConcurrentApiCalls, this.orgIdToBundleMap, NORMAL_BUNDLE_FACTORY);
    }

    @Override
    public synchronized void configureSandboxOrg(@Nonnull T orgId, @Nonnull String username, @Nonnull String password, int maxConcurrentApiCalls) {
        this.configureOrgImpl(orgId, username, password, maxConcurrentApiCalls, this.orgIdToSandboxBundleMap, SANDBOX_BUNDLE_FACTORY);
    }

    private void configureOrgImpl(T orgId, String username, String password, int maxConcurrentApiCalls, Map<T, ConnectionBundleImpl> bundles, BundleFactory bundleFactory) {
        ConnectionBundleImpl cp = bundles.get(orgId);
        if (cp == null) {
            logger.debug("Initial configuration for org " + orgId);
            bundles.put(orgId, bundleFactory.getBundle(this.bindingRepository, username, password, maxConcurrentApiCalls, this.metricRegistry));
        } else {
            logger.debug("Updating existing configuration for org " + orgId);
            cp.updateCredentials(username, password, maxConcurrentApiCalls);
        }
    }

    @Immutable
    private static class SandboxBundleFactory
    implements BundleFactory {
        private SandboxBundleFactory() {
        }

        @Override
        @Nonnull
        public ConnectionBundleImpl getBundle(@Nonnull BindingRepository bindingRepository, @Nonnull String username, @Nonnull String password, int maxConcurrentApiCalls, MetricRegistry metricRegistry) {
            return ConnectionBundleImpl.getNewForSandbox(bindingRepository, username, password, maxConcurrentApiCalls, metricRegistry);
        }
    }

    @Immutable
    private static class NormalBundleFactory
    implements BundleFactory {
        private NormalBundleFactory() {
        }

        @Override
        @Nonnull
        public ConnectionBundleImpl getBundle(@Nonnull BindingRepository bindingRepository, @Nonnull String username, @Nonnull String password, int maxConcurrentApiCalls, MetricRegistry metricRegistry) {
            return ConnectionBundleImpl.getNew(bindingRepository, username, password, maxConcurrentApiCalls, metricRegistry);
        }
    }

    @ThreadSafe
    private static interface BundleFactory {
        @Nonnull
        public ConnectionBundleImpl getBundle(@Nonnull BindingRepository var1, @Nonnull String var2, @Nonnull String var3, int var4, MetricRegistry var5);
    }
}

